/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

#include "apr.h"        /* configuration data */
/**
 * @file apr_want.h
 * @brief APR_WANT_XXX documentation
 *
 * <PRE>
 * Features:
 *
 *   APR_WANT_STRFUNC:  strcmp, strcat, strcpy, etc
 *   APR_WANT_MEMFUNC:  memcmp, memcpy, etc
 *   APR_WANT_STDIO:    <stdio.h> and related bits
 *   APR_WANT_IOVEC:    struct iovec
 *   APR_WANT_SIGNAL:   signal numbers, functions, and types
 *   APR_WANT_BYTEFUNC: htons, htonl, ntohl, ntohs
 *
 * Typical usage:
 *
 *   #define APR_WANT_STRFUNC
 *   #define APR_WANT_MEMFUNC
 *   #include "apr_want.h"
 *
 * The appropriate headers will be included.
 *
 * Note: it is safe to use this in a header (it won't interfere with other
 *       headers' or source files' use of apr_want.h)
 * </PRE>
 */

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_STRFUNC

#if APR_HAVE_STRING_H
#include <string.h>
#endif
#if APR_HAVE_STRINGS_H
#include <strings.h>
#endif

#undef APR_WANT_STRFUNC
#endif

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_MEMFUNC

#if APR_HAVE_STRING_H
#include <string.h>
#endif

#undef APR_WANT_MEMFUNC
#endif

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_STDIO

#if APR_HAVE_STDIO_H
#include <stdio.h>
#endif

#undef APR_WANT_STDIO
#endif

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_IOVEC

#if APR_HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif

#undef APR_WANT_IOVEC
#endif

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_SIGNAL

#if APR_HAVE_SIGNAL_H
#include <signal.h>
#endif
/* ### some platforms may put this into unistd.h ?? */

#undef APR_WANT_SIGNAL
#endif

/* --------------------------------------------------------------------- */

#ifdef APR_WANT_BYTEFUNC

/* Single Unix says they are in arpa/inet.h.  Linux has them in
 * netinet/in.h.  FreeBSD has them in arpa/inet.h but requires that
 * netinet/in.h be included first.
 */
#if APR_HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#if APR_HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#undef APR_WANT_BYTEFUNC
#endif

/* --------------------------------------------------------------------- */
