<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<!-- Traduction anglais 1.17 -->
<head>
<meta http-equiv="Content-Type" content=
"text/html; charset=iso-8859-1">
<title>Fichiers de configuration</title>
</head>
<!-- Background white, links blue (unvisited), navy (visited), red (active) -->
<body bgcolor="#FFFFFF" text="#000000" link="#0000FF" vlink=
"#000080" alink="#FF0000">
<!--#include virtual="header.html" -->
<h1 align="CENTER">Fichiers de configuration</h1>

<ul>
<li><a href="#main">Principaux fichiers de configuration</a></li>
<li><a href="#syntax">Syntaxe des fichiers de
configuration</a></li>
<li><a href="#modules">Modules</a></li>
<li><a href="#scope">Porte des directives</a></li>
<li><a href="#htaccess">Fichiers .htaccess</a></li>
<li><a href="#logs">Fichiers de trace</a></li>
</ul>

<hr>
<h2><a name="main">Principaux fichiers de configuration</a></h2>

<table border="1">
<tr>
<td valign="top"><strong>Modules lis</strong><br>
<br>
<a href="mod/mod_mime.html">mod_mime</a><br>
</td>
<td valign="top"><strong>Directives lies</strong><br>
<br>
<a href="mod/core.html#accessconfig">AccessConfig</a><br>
<a href="mod/core.html#ifdefine">&lt;IfDefine&gt;</a><br>
<a href="mod/core.html#include">Include</a><br>
<a href="mod/core.html#resourceconfig">ResourceConfig</a><br>
<a href="mod/mod_mime.html#typesconfig">TypesConfig</a><br>
</td>
</tr>
</table>

<p>Apache se configure en plaant des <a href=
"mod/directives.html">directives</a> dans des fichiers textes de
configuration. Le fichier de configuration principal est
gnralement appel <code>httpd.conf</code>.
L'emplacement de ce fichier est fix  la
compilation, mais peut tre redfini en utilisant
l'option de ligne de commande <code>-f</code>. Certains sites
possdent galement des fichiers
<code>srm.conf</code> et <code>access.conf</code> pour des <a
href="http://www.apache.org/info/three-config-files.html">raisons
historiques</a>. De plus, d'autres fichiers de configuration
peuvent tre ajouts en utilisant la directive
<code><a href="mod/core.html#include">Include</a></code>. Les
directives peuvent tre places dans n'importe quel
fichier. Les modifications dans le fichier de configuration
principal ne sont prises en compte qu'au dmarrage ou
au redmarrage d'Apache.</p>

<p>Une nouveaut de la version 1.3.13 d'Apache est la
possibilit qu'un fichier de configuration soit en fait un
rpertoire. Dans ce cas, Apache lira tous les fichiers et
sous rpertoires et les traitera comme fichiers de
configuration. Une utilisation possible de cette
fonctionnalit est de pouvoir ajouter des htes
virtuels en crant des fichiers de configuration pour
chaque hte, et de les placer dans le rpertoire de
configuration. Ainsi, vous pouvez ajouter ou retirer des
htes virtuels sans avoir  diter de
fichiers, mais simplement en ajoutant ou supprimant un fichier.
Cel permet d'automatiser plus facilement ce genre de
traitement.</p>

<p>Le serveur lit galement un fichier dcrivant
les types de contenu MIME; le nom de ce fichier est
dfini par la directive <a href=
"mod/mod_mime.html#typesconfig">TypesConfig</a> et est par
dfaut <code>mime.types</code>.</p>

<hr>
<h2><a name="syntax">Syntaxe des fichiers de
configuration</a></h2>

<p>Les fichiers de configurations contiennent au plus une
directive par ligne. Le caractre &quot;\&quot; peut tre
utilis  la fin d'une ligne pour indiquer que la
directive se poursuit sur la ligne suivante. Il ne doit pas y
avoir d'autres caractre ou d'espace entre le
caractre &quot;\&quot; et la fin de la ligne.</p>

<p>Dans les fichiers de configuration, l'criture des noms
des directives n'est pas sensible  la casse, mais les
arguments des directives le sont gnralement. Les
lignes blanches et les espaces prcdant une
directive sont ignors. Les commentaires <strong>ne
doivent pas</strong> tre inclus sur la mme ligne
qu'une directive. Les lignes commenant par le
caractre dise "#" sont traites comme des
commentaires et sont ignors; vous pouvez les utiliser
pour indenter les directives et rendre leur lecture plus
facile.</p>

<p>Vous pouvez vrifier la syntaxe de vos fichiers de
configuration en utilisant soit <code>apachectl configtest</code>
soit l'option de ligne de commande <code>-t</code>.</p>

<hr>
<h2><a name="modules">Modules</a></h2>

<table border="1">
<tr>
<td valign="top"><strong>Modules lis</strong><br>
<br>
<a href="mod/mod_so.html">mod_so</a><br>
</td>
<td valign="top"><strong>Directives lies</strong><br>
<br>
<a href="mod/core.html#addmodule">AddModule</a><br>
<a href="mod/core.html#clearmodulelist">ClearModuleList</a><br>
<a href="mod/core.html#ifmodule">&lt;IfModule&gt;</a><br>
<a href="mod/mod_so.html#loadmodule">LoadModule</a><br>
</td>
</tr>
</table>

<p>Apache est un serveur modulaire. Cel implique que seules les
fonctions de base sont incluses dans le noyau du serveur. Les
fonctionnalits plus avances sont disponibles
grce aux <a href="mod/index-bytype.html">modules</a> qui
peuvent tre chargs dans Apache. Par dfaut,
un ensemble de modules de <a href=
"mod/module-dict.html#Status">base</a> sont inclus  la
compilation. Si le serveur est compil pour utiliser les
modules <a href="dso.html">dynamiquement chargs</a>,
alors les modules peuvent tre compils
sparment et ajout  n'importe quel
moment en utilisant la directive <a href=
"mod/mod_so.html#loadmodule">LoadModule</a>. Sinon, Apache doit
tre recompil pour ajouter ou supprimer des
modules. Des directives de configuration peuvent tre
incluses de manire conditionnelle en fonction de la
prsence d'un module particulier en les entourant par un
bloc <a href="mod/core.html#ifmodule">&lt;IfModule&gt;</a>.</p>

<p>Pour savoir quels modules ont t compils
dans le serveur, vous pouvez utiliser l'option de ligne de
commande <code>-l</code>.</p>

<hr>
<h2><a name="scope">Porte des directives</a></h2>

<table border="1">
<tr>
<td valign="top"><strong>Directives lies</strong><br>
<br>
<a href="mod/core.html#directory">&lt;Directory&gt;</a><br>
<a href=
"mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a><br>
<a href="mod/core.html#files">&lt;Files&gt;</a><br>
<a href="mod/core.html#filesmatch">&lt;FilesMatch&gt;</a><br>
<a href="mod/core.html#location">&lt;Location&gt;</a><br>
<a href=
"mod/core.html#locationmatch">&lt;LocationMatch&gt;</a><br>
<a href="mod/core.html#virtualhost">&lt;VirtualHost&gt;</a><br>
</td>
</tr>
</table>

<p>Les directives places dans les principaux fichiers de
configuration s'appliquent  l'ensemble du serveur. Si
vous souhaitez modifier la configuration pour une partie
seulement du serveur, vous pouvez mettre en contexte vos
directives en les plaant dans des sections <code><a href=
"mod/core.html#directory">&lt;Directory&gt;</a>, <a href=
"mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a>, <a
href="mod/core.html#files">&lt;Files&gt;</a>, <a href=
"mod/core.html#filesmatch">&lt;FilesMatch&gt;</a>, <a href=
"mod/core.html#location">&lt;Location&gt;</a>,</code> et <code><a
href=
"mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code> .
Ces sections limitent la porte d'application des
directives qu'elles contiennent  un emplacement des
fichiers ou  certaines URL. Elles peuvent tre
imbriques, permettant ainsi une configuration trs
fine.</p>

<p>Apache a la possibilit de servir plusieurs sites web
simultanment. Cette possibilit est appele
<a href="vhosts/">hbergement virtuel</a>. Des directives
peuvent galement tre limites en utilisant
des sections <code><a href=
"mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> afin
qu'elles ne s'appliquent qu' certains sites web.</p>

<p>Bien que la plupart des directives peuvent tre
places  l'intrieur de n'importe quelle
section, certaines directives n'ont pas de sens dans certains
contextes. Par exemple, les directives contrlant la
cration des processus ne peuvent tre places
que dans le contexte pricipal du serveur. Pour savoir quelles
directives peuvent tre places dans quelles
sections, vrifiez le <a href=
"mod/directive-dict.html#Context">contexte</a> de la directive.
Pour plus d'informations, voir <a href="sections.html">comment
les sections Directory, Location et Files fonctionnent</a>.</p>

<hr>
<h2><a name="htaccess">Fichiers .htaccess</a></h2>

<table border="1">
<tr>
<td valign="top"><strong>Directives lies</strong><br>
<br>
<a href="mod/core.html#accessfilename">AccessFileName</a><br>
<a href="mod/core.html#allowoverride">AllowOverride</a><br>
</td>
</tr>
</table>

<p>Apache permet une gestion dcentralise de la
configuration par l'utilisation de fichiers spciaux
 l'intrieur de l'arborescence web. Ces fichiers
spciaux sont gnralement appels
<code>.htaccess</code>, mais n'importe quel nom peut tre
dfini par la directive <a href=
"mod/core.html#accessfilename"><code>AccessFileName</code></a>.
Les directives places dans les fichiers
<code>.htaccess</code> s'appliquent au rpertoire
o se trouve le fichier ainsi qu'aux sous
rpertoires. Les fichiers <code>.htaccess</code>
respectent la mme syntaxe que les fichiers principaux de
configuration. Comme les fichiers <code>.htaccess</code> sont lus
 chaque requte, Les modifications
effectues dans ces fichiers prennent effet
immdiatement.</p>

<p>Pour savoir si une directive peut tre place
dans les fichiers <code>.htaccess</code>, vrifiez le <a
href="mod/directive-dict.html#Context">contexte</a> de la
directive. L'administrateur peut contler quelles
directives peuvent tre places dans les fichiers
<code>.htaccess</code> en modifiant la directive <a href=
"mod/core.html#allowoverride"><code>AllowOverride</code></a> du
fichier principal de configuration.</p>

<hr>
<h2><a name="logs">Fichiers de trace</a></h2>

<h3>Avertissement sur la scurit</h3>

Toute personne pouvant crire dans le rpertoire
o Apache crit un fichier de trace peut avoir
accs  l'uid sous lequel le serveur est
lanc, gnralement root. <em>Ne donnez
pas</em> accs en criture au rpertoire
o les fichiers de trace sont stocks sans
tre clairement conscient des consquences; voir le
document <a href="misc/security_tips.html">trucs sur la
scurit</a> pour plus de dtails. 

<h3>Fichier pid</h3>

<p>Au lancement, Apache crit le numro de
processus du processus pre httpd dans le fichier
<code>logs/httpd.pid</code>. Le nom du fichier peut tre
chang en modifiant la directive <a href=
"mod/core.html#pidfile">PidFile</a>. Le numro de
processus est utilis par l'administrateur pour relancer
et arrter le dmon. Sur Unix, un signal HUP ou USR1
a pour effet de faire relire par le dmon les fichiers de
configuration, et un signal TERM le fait terminer de
manire douce. Sur Windows, il faut employer l'option -k.
Pour plus d'information voir la page <a href=
"stopping.html">Arrt et redmarrage</a>.</p>

<p>Si le processus meurt (ou est tu) de manire
anormale, il peut alors tre ncessaire de tuer les
processus fils.</p>

<h3>Trace des erreurs</h3>

<p>Le serveur trace les messages d'erreurs dans un fichier, par
dfaut <code>logs/error_log</code> sur Unix ou
<code>logs/error.log</code> sur Windows and OS/2. Le nom du
fichier peut tre dfini en utilisant la directive
<a href="mod/core.html#errorlog">ErrorLog</a> D'autres traces
peuvent tre dfinies pour diffrents <a
href="mod/core.html#virtualhost">htes virtuels</a>.</p>

<h3>Trace des requtes</h3>

<p>Le serveur trace gnralement chaque
requte dans un fichier de transfert, par dfaut
<code>logs/access_log</code> sur Unix ou
<code>logs/access.log</code> sur Windows and OS/2. Le nom du
fichier peut tre dfini en utilisant la directive
<a href="mod/mod_log_config.html#customlog">CustomLog</a>.
D'autres traces peuvent tre dfinies pour
diffrents <a href="mod/core.html#virtualhost">htes
virtuels</a>. <!--#include virtual="footer.html" -->
</p>
</body>
</html>

