/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1998 Hubert Figuiere

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _PDF_WINDOW_
#define _PDF_WINDOW_

#pragma once

#include <interface/TextControl.h>

#include "HWindow.h"

#include "PDFView.h"

/*#include "PageGadget.h"*/

class PDFWindow
	: public HWindow
{
public:
	PDFWindow (entry_ref * ref, BRect frame);
virtual ~PDFWindow();

virtual	bool CanClose();
	bool IsOk();
	void SetUpViews (entry_ref * ref);
	
	
virtual void FrameResized (float width, float height);
virtual void MessageReceived (BMessage * message);

	void SetZoomSize (float w, float h);

	enum {
		PAGE_CHANGE_NOTIFY_MSG = 'Page'	/*message of page change notification*/
	};
static char * PAGE_MSG_LABEL;
protected:
virtual void HandleCommand ( int32 cmd, BMessage * msg );

private:
	PDFView * mMainView;
	BTextControl * mPageNumberItem;
	BMessage * mPrintSettings;
	BStringView * mTotalPageNumberItem;
	/*PageGadget * mPageGadget;*/
	/*BPopUpMenu * mPagePopup;*/

	enum {
		OPEN_FILE_CMD = 10,
		CLOSE_FILE_CMD,
		PRINT_FILE_CMD,
		QUIT_APP_CMD,
		ABOUT_APP_CMD,
		NEXT_PAGE_CMD,
		PREVIOUS_PAGE_CMD,
		PAGESETUP_FILE_CMD,
		GOTO_PAGE_CMD,
		GOTO_PAGE_MENU_CMD,
		SET_ZOOM_VALUE_CMD,
		SET_MAC_ENCODING_CMD,
		SET_ISO_ENCODING_CMD
	};
	
	enum {
		TOOLBAR_HEIGHT = 40,
		TOOLBAR_BOTTOM = TOOLBAR_HEIGHT + 18,
		TOOLBUTTON_OFFSET = 9,
		SCROLLBAR_SIZE = 16,
		PAGE_POPUP_WIDTH = 50
	};
};


//////////////////////////////////////////////////////////////////
inline bool PDFWindow::IsOk()
{
	if (mMainView != NULL) {
		return mMainView->IsOk();
	}
	else {
		return false;
	}
}




//////////////////////////////////////////////////////////////////


#endif
