/*

*/





#include "PageGadget.h"


static rgb_color ltGray = { 238, 238, 238, 0 };

//////////////////////////////////////////////////////////////////////////
PageGadget::PageGadget (const BRect & frame, const char * name,
	            uint32 resizingMode)
	: BView (frame, name, resizingMode, B_WILL_DRAW | B_NAVIGABLE)
{
	mPopup = new BPopUpMenu ("page");
	mTarget = NULL;
	mMessage = NULL;
	mPage = 0;
	
	frame.PrintToStream();
}



//////////////////////////////////////////////////////////////////////////
PageGadget::~PageGadget ()
{
	delete mPopup;
}



//////////////////////////////////////////////////////////////////////////
void PageGadget::AttachedToWindow(void)
{
	fprintf (stderr, "AttachedToWindow()\n");
	SetViewColor (ltGray);
	SetFont (be_bold_font);
}

//////////////////////////////////////////////////////////////////////////
void PageGadget::SetMessage (BMessage * msg)
{
	if (msg == NULL) {
		delete mMessage;
		mMessage = NULL;
	}
	else {
		mMessage = new BMessage (msg);
	}
}


//////////////////////////////////////////////////////////////////////////
void PageGadget::Draw (BRect updateRect)
{
	fprintf (stderr, "PageGadget::Draw()\n");

	char str [16];
	
	sprintf (str, "%d", mPage);
	DrawString (str, BPoint (5.0, Bounds().bottom - 3.0));
}


//////////////////////////////////////////////////////////////////////////
