/*  
	BeOS Front-end du PDF file reader xpdf.
    Copyright (C) 1998 Hubert Figuiere

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <app/Application.h>
#include "HWindow.h"


BList HWindow::windowList;
BLocker HWindow::windowListLocker; 

const char * CMD_IDX_LABEL = "cmd";


//////////////////////////////////////////////////////////////
HWindow::HWindow(BRect frame, const char * label, window_type type,
									ulong flags, bool quitWhenClosed, ulong workSp)
	: BWindow(frame, label, type, flags, workSp),
	mQuitWhenClosed(quitWhenClosed)
{
	
	if (mQuitWhenClosed) {
		if (windowListLocker.Lock()) {
			windowList.AddItem(this);
			windowListLocker.Unlock();
		} //if
	}
}


//////////////////////////////////////////////////////////////
HWindow::~HWindow()
{
	if (mQuitWhenClosed) {
		if (windowListLocker.Lock()) {
			windowList.RemoveItem(this);
			windowListLocker.Unlock();
		} //if
		if (windowList.CountItems() == 0) {
			be_app->PostMessage(B_QUIT_REQUESTED);
		}
	}
}


#pragma mark -

//////////////////////////////////////////////////////////////
//void HWindow::DispatchMessage(BMessage * msg, BHandler * handler)
void HWindow::MessageReceived(BMessage * msg)
{
	status_t err;
	int32 cmd;
	
	switch(msg->what) {
	case STANDARD_CMD_MSG:
		err = msg->FindInt32(CMD_IDX_LABEL, &cmd);
		if (err == B_NO_ERROR) {
			HandleCommand(cmd, msg);
		}	
		break;
	default:
		inherited::MessageReceived(msg);
		break;
	}		
}



#pragma mark -


//////////////////////////////////////////////////////////////
BMessage * HWindow::MakeCommandMessage(ulong cmd)
{
	BMessage * aMsg = new BMessage(STANDARD_CMD_MSG);
	aMsg->AddInt32(CMD_IDX_LABEL, cmd);
	
	return aMsg;	
}


//////////////////////////////////////////////////////////////

