/*****************************************************************************************************************
 audio_sound_driver.h Source the below too .h files merged together by Earl Colby Pottinger.

 sound.h   Source: /boot/cvsroot/joe/audio_drive/sound.h,v
 Revision: 1.3 Author: joe Date: 1999/11/03 16:40:40 Copyright (c) 1994 by Be Incorporated. All Rights Reserved.
 Data structures and control calls for using the sound driver.
 
 audio_driver.h  Jon Watte 1997/12/23  Interface to drivers found in /dev/audio.  Devices found in /dev/audio/old
 follow a different API! Copyright 1999, Be Incorporated.  All Rights Reserved.  This file may be used under
 the terms of the Be Sample Code License.*/

#if !defined(_AUDIO_DRIVER_H)
#define _AUDIO_DRIVER_H

#if !defined(_SUPPORT_DEFS_H)
#include <SupportDefs.h>
#endif /* _SUPPORT_DEFS_H */

#if !defined(_DRIVERS_H)
#include <Drivers.h>
#endif /* _DRIVERS_H */

enum sample_format { /* Obsolete? Always 16bit-linear. */
 linear_8bit_unsigned_mono = 0,   linear_8bit_unsigned_stereo,
 ulaw_8bit_companded_mono,        ulaw_8bit_companded_stereo,
 linear_16bit_little_endian_mono, linear_16bit_little_endian_stereo,
 alaw_8bit_companded_mono,        alaw_8bit_companded_stereo,
 sample_format_reserved_1,        sample_format_reserved_2,
 adpcm_4bit_mono,                 adpcm_4bit_stereo, 
 linear_16bit_big_endian_mono,    linear_16bit_big_endian_stereo,
 sample_format_reserved_3,        sample_format_reserved_4 };

enum adc_source { line=0, aux1, mic, loopback };

enum sample_rate {
 kHz_8_0 = 0, kHz_5_51, kHz_16_0, kHz_11_025, kHz_27_42, kHz_18_9, kHz_32_0, kHz_22_05,
 kHz_37_8 = 9, kHz_44_1 = 11, kHz_48_0, kHz_33_075, kHz_9_6, kHz_6_62 };

enum { // control opcodes for sound driver.
 /* arg = ptr to struct audio_format */
 B_AUDIO_GET_AUDIO_FORMAT = B_AUDIO_DRIVER_BASE, B_AUDIO_SET_AUDIO_FORMAT,
 /* arg = ptr to float[4] */
 B_AUDIO_GET_PREFERRED_SAMPLE_RATES,
 /* arg = ptr to struct audio_routing_cmd */
 B_ROUTING_GET_VALUES, B_ROUTING_SET_VALUES,
 /* arg = ptr to struct audio_routing_cmd */
 B_MIXER_GET_VALUES, B_MIXER_SET_VALUES,
 /* arg = ptr to struct audio_timing */
 B_AUDIO_GET_TIMING, /* used to be SV_SECRET_HANDSHAKE (10100) */
 B_MIXER_GET_SCOPE = B_AUDIO_DRIVER_BASE + 99,/* SB16 driver extension */
 SOUND_GET_PARAMS = B_DEVICE_OP_CODES_END,  // Additional Codes.
 SOUND_SET_PARAMS, /* 10000 */
 SOUND_SET_PLAYBACK_COMPLETION_SEM,    SOUND_SET_CAPTURE_COMPLETION_SEM, /* 10001-2 */
 SOUND_GET_PLAYBACK_TIMESTAMP,         SOUND_GET_CAPTURE_TIMESTAMP,      /* 10003-4 */
 SOUND_DEBUG_ON,                       SOUND_DEBUG_OFF,                  /* 10005-6 */
 SOUND_WRITE_BUFFER,                   SOUND_READ_BUFFER,                /* 10007-8 */
 SOUND_LOCK_FOR_DMA, /* 10009 */
 SOUND_SET_CAPTURE_PREFERRED_BUF_SIZE, SOUND_SET_PLAYBACK_PREFERRED_BUF_SIZE, /* 10010-11 */
 SOUND_GET_CAPTURE_PREFERRED_BUF_SIZE, SOUND_GET_PLAYBACK_PREFERRED_BUF_SIZE  /* 10012-13 */};

struct channel {
 enum adc_source adc_source; /* adc input source */
 char adc_gain;        /* 0..15 adc gain, in 1.5 dB steps */
 char mic_gain_enable; /* non-zero enables 20 dB MIC input gain */
 char aux1_mix_gain;   /* 0..31 aux1 mix to output gain. 12.0 to -34.5 dB in 1.5dB steps */
 char aux1_mix_mute;   /* non-zero mutes aux1 mix */
 char aux2_mix_gain;   /* unused */
 char aux2_mix_mute;   /* unused */
 char line_mix_gain;   /* 0..31 line mix to output gain. 12.0 to -34.5 dB in 1.5dB steps */
 char line_mix_mute;   /* non-zero mutes line mix */
 char dac_attn;        /* 0..61 dac attenuation, in -1.5 dB steps */
 char dac_mute; };     /* non-zero mutes dac output */

typedef struct sound_setup {
 struct channel     left;            /* left channel setup */
 struct channel     right;           /* right channel setup */
 enum sample_rate   sample_rate;     /* sample rate */
 enum sample_format playback_format; /* sample format for playback. Obsolete? Always 16bit-linear. */
 enum sample_format capture_format;  /* sample format for capture.  Obsolete? Always 16bit-linear. */
 char               dither_enable;   /* non-zero enables dither on 16 => 8 bit */
 char               loop_attn;       /* 0..64 adc to dac loopback attenuation, in -1.5 dB steps */
 char               loop_enable;     /* non-zero enables loopback */
 char               output_boost;    /* zero (2.0 Vpp) non-zero (2.8 Vpp) output level boost */
 char               highpass_enable; /* non-zero enables highpass filter in adc */
 char               mono_gain;       /* 0..64 mono speaker gain */
 char               mono_mute;       /* non-zero mutes speaker */
} sound_setup;

/* this is the definition of what the audio driver can do for you */
typedef struct audio_format {
 float  sample_rate;        /* ~4000 - ~48000, maybe more */
 int32  channels;           /* 1 or 2 */
 int32  format;             /* 0x11 (uchar), 0x2 (short), or 0x24 (float) secret format of format:
                               upper nybble = signed, unsigned, float lower nybble = bytes per sample */
 int32  big_endian;         /* 0 for little endian, 1 for big endian */
 size_t buffer_header;      /* typically 0 or 16 */
 size_t write_buffer_size;  /* size of playback buffer (latency) */
 size_t record_buffer_size; /* size of record buffer (latency) */
} audio_format;

typedef struct audio_buffer_header {
 int32     buffer_number;
 int32     subscriber_count;
 bigtime_t time;       // System_Time data will play?
 int32     reserved_1; // size of audio_buffer_header + sound data that follows
 int32     reserved_2;
 bigtime_t sample_clock; // 1000000 * actual frequency / requested frequency
} audio_buffer_header;

/* when buffer header is in effect, this is what gets read before data */
typedef struct audio_buf_header {
 bigtime_t capture_time;
 uint32    capture_size;
 float     sample_rate;
} audio_buf_header;

/* the mux devices use these records */
typedef struct audio_routing {
 int32 selector; /* for GET, these need to be filled in! */
 int32 value;
} audio_routing;

/* this is the argument for ioctl() */
typedef struct audio_routing_cmd {
 int32 count;
 audio_routing* data;
} audio_routing_cmd;

typedef struct {
 bigtime_t   wr_time;
 bigtime_t   rd_time;
 uint32      wr_skipped;
 uint32      rd_skipped;
 uint64      wr_total;
 uint64      rd_total;
 uint32      _reserved_[6];
} audio_timing;

/* the mixer devices use these records */
typedef struct audio_level {
 int32  selector; /* for GET, this still needs to be filled in! */
 uint32 flags;
 float  value;    /* in dB */
} audio_level;

/* this is the arg to ioctl() */
typedef struct audio_level_cmd {
 int32 count;
 audio_level* data;
} audio_level_cmd;

enum { /* selectors for routing */
 B_AUDIO_INPUT_SELECT,
 B_AUDIO_MIC_BOOST,
 B_AUDIO_MIDI_OUTPUT_TO_SYNTH,
 B_AUDIO_MIDI_INPUT_TO_SYNTH,
 B_AUDIO_MIDI_OUTPUT_TO_PORT,
 B_AUDIO_PCM_OUT_POST_3D,
 B_AUDIO_STEREO_ENHANCEMENT,
 B_AUDIO_3D_STEREO_ENHANCEMENT,
 B_AUDIO_BASS_BOOST,
 B_AUDIO_LOCAL_LOOPBACK,
 B_AUDIO_REMOTE_LOOPBACK,
 B_AUDIO_MONO_OUTPUT_FROM_MIC,
 B_AUDIO_ALTERNATE_MIC,
 B_AUDIO_ADC_DAC_LOOPBACK };

enum { /* input MUX source values */
 B_AUDIO_INPUT_DAC = 1, /* (not in AC97) */
 B_AUDIO_INPUT_LINE_IN,
 B_AUDIO_INPUT_CD,
 B_AUDIO_INPUT_VIDEO,
 B_AUDIO_INPUT_AUX1, /* synth */
 B_AUDIO_INPUT_AUX2, /* (not in AC97) */
 B_AUDIO_INPUT_PHONE,
 B_AUDIO_INPUT_MIC,
 B_AUDIO_INPUT_MIX_OUT, /* sum of all outputs */
 B_AUDIO_INPUT_MONO_OUT };

/* bitmask for the flags */
#define B_AUDIO_LEVEL_MUTED 1

enum {	/* selectors for levels */
 B_AUDIO_MIX_ADC_LEFT,           B_AUDIO_MIX_ADC_RIGHT,
 B_AUDIO_MIX_DAC_LEFT,           B_AUDIO_MIX_DAC_RIGHT,
 B_AUDIO_MIX_LINE_IN_LEFT,       B_AUDIO_MIX_LINE_IN_RIGHT,
 B_AUDIO_MIX_CD_LEFT,            B_AUDIO_MIX_CD_RIGHT,
 B_AUDIO_MIX_VIDEO_LEFT,         B_AUDIO_MIX_VIDEO_RIGHT,
 B_AUDIO_MIX_SYNTH_LEFT,         B_AUDIO_MIX_SYNTH_RIGHT,
 B_AUDIO_MIX_AUX_LEFT,           B_AUDIO_MIX_AUX_RIGHT, /* (neither in AC97) */
 B_AUDIO_MIX_PC_BEEP, B_AUDIO_MIX_PHONE, B_AUDIO_MIX_MIC,
 B_AUDIO_MIX_LINE_OUT_LEFT,      B_AUDIO_MIX_LINE_OUT_RIGHT,
 B_AUDIO_MIX_HEADPHONE_OUT_LEFT, B_AUDIO_MIX_HEADPHONE_OUT_RIGHT,
 B_AUDIO_MIX_MONO_OUT,           B_AUDIO_MIX_LOOPBACK_LEVEL }; /* (not in AC97) */

#endif /* _AUDIO_DRIVER_H */



