#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Alert.h>
#include <Beep.h>
#include <FilePanel.h>
#include <MenuItem.h>
#include <NodeInfo.h>
#include <Screen.h>
#include <TextView.h>
#include <WindowScreen.h>
#include <PropertyInfo.h>

#include "KApp.h"
#include "KWindow.h"
#include "KPrefs.h"
#include "KMenuBar.h"
#include "KPrefsWindow.h"
#include "KFindWindow.h"
#include "KGoToLineWindow.h"


KApp::KApp() : BApplication(kMySignature)
{
	fWindowList.MakeEmpty();
	fOpenPanel	= NULL;
	fPrefs		= new KPrefs(kSettingFile, kSettingDir);
	fPrefsWindow = NULL;
	fGoToLineWindow = NULL;
	
	this->MakeFindWindow();
}

KApp::~KApp()
{
	delete	fPrefs;
}

int main()
{
	KApp* app = new KApp();
	app->Run();
	delete app;
	return EXIT_SUCCESS;
}

void
KApp::MessageReceived(BMessage* msg)
{
	KWindow*	aWindow = NULL;
	
	switch(msg->what){
		case K_NEW:
			aWindow = this->MakeNewWindow();
			
			if(msg->IsSourceRemote()){
				BMessenger	aWindowMessenger(aWindow);
				BMessage	aMessage(K_NEW);
				aMessage.AddMessenger("window_messenger", aWindowMessenger);
				BMessenger	aMessenger = msg->ReturnAddress();
				aMessenger.SendMessage(&aMessage);
				const char*	aTitle;
				if(msg->FindString("title", &aTitle) == B_NO_ERROR){
					aWindow->SetTitle(aTitle);
				}
			}else{
				const char	*aContent, *aTitle;
				if(msg->FindString("content", &aContent) == B_NO_ERROR
						&& msg->FindString("title", &aTitle) == B_NO_ERROR){
					aWindow->SetTitle(aTitle);
					dynamic_cast<BTextView*>(aWindow->FindView("textview"))->SetText(aContent);
				}
			}
			
			
			aWindow->Show();
			break;
			
		case K_OPEN:
			if(fOpenPanel == NULL)
				fOpenPanel = new BFilePanel();
			fOpenPanel->Show();
			break;
		
		case K_REMOVE_WINDOW_POINTER:
			msg->FindPointer("window", (void **) &aWindow);
			fWindowList.RemoveItem(aWindow);
			if(fWindowList.CountItems() == 0){
				this->PostMessage(B_QUIT_REQUESTED);
			}
			break;
			
		case K_SWITCH_WINDOW:
			{
				int32	index;
				msg->FindInt32("index", &index);
				((KWindow*)fWindowList.ItemAt(index))->Activate();
				break;
			}
		case K_SHOW_GO_TO_LINE_WINDOW:
			{
				if(fGoToLineWindow == NULL){
					BRect aRect(kGoToLineWindowRect);
					aRect.OffsetTo(200, 200);
					fGoToLineWindow = new KGoToLineWindow(aRect);
				}
				msg->FindPointer("window", (void**)&aWindow);
				fGoToLineWindow->Lock();
				fGoToLineWindow->SetTargetWindow(aWindow);
				fGoToLineWindow->SetWorkspaces(aWindow->Workspaces());
				if(fGoToLineWindow->IsHidden()){
					fGoToLineWindow->Show();
				}
				fGoToLineWindow->Activate();
				fGoToLineWindow->Unlock();
				
				break;
			}
			
		case K_FIND:
			msg->FindPointer("window", (void **) &aWindow);
			fFindWindow->Lock();
			fFindWindow->SetTargetWindow(aWindow);
			aWindow->Lock();
			fFindWindow->SetWorkspaces(aWindow->Workspaces());
			aWindow->Unlock();
			
			//for "ffm" function...
			if(::focus_follows_mouse()){
				const int32	kMouseMoveDev = 50;
				BRect		aFrame(fFindWindow->Frame());
				BPoint		aCurMouseLoc;
				BPoint		aDestMouseLoc(aFrame.LeftTop().x + 30, aFrame.LeftTop().y + 30);
				uint32		aButton;
				
				BView*		aFindView = fFindWindow->FindView("find_view");
				
				aFindView->GetMouse(&aCurMouseLoc, &aButton);
				aFindView->ConvertToScreen(&aCurMouseLoc);
				
				for(int32 i = 0; i < kMouseMoveDev; i++){
					float	aX = aCurMouseLoc.x + i * (aDestMouseLoc.x - aCurMouseLoc.x)/kMouseMoveDev;
					float	aY = aCurMouseLoc.y + i * (aDestMouseLoc.y - aCurMouseLoc.y)/kMouseMoveDev;
					::set_mouse_position((int32)aX, (int32)aY);
					::snooze(1000);
				}
				
			}
			
			if(fFindWindow->IsHidden()){
				fFindWindow->Show();
			}
			fFindWindow->Activate();
			fFindWindow->Unlock();
			break;
		case K_FIND_AGAIN:
			msg->FindPointer("window", (void**) &aWindow);
			fFindWindow->Lock();
			fFindWindow->PostMessage(msg);
			fFindWindow->Unlock();
			break;
		case K_REPLACE:
			msg->FindPointer("window", (void **) &aWindow);
			fFindWindow->Lock();
			fFindWindow->SetTargetWindow(aWindow);
			fFindWindow->Replace();
			fFindWindow->Unlock();
			break;
		case K_REPLACE_AND_FIND_AGAIN:
			msg->FindPointer("window", (void **) &aWindow);
			fFindWindow->Lock();
			fFindWindow->SetTargetWindow(aWindow);
			fFindWindow->Replace();
			fFindWindow->Find();
			fFindWindow->Unlock();
			break;
			
		case K_SHOW_PREFS_WINDOW:
			this->ShowPrefsWindow();
			break;
		
		case K_GET_FRONTMOST_WINDOW:
			{/*
				int32	aWindowCount = fWindowList.CountItems();
				for(int32 i = 0; i < aWindowCount; i++){
					BWindow*	window = (KWindow*)fWindowList.ItemAt(i);
					if(window->IsFront()){
						BMessenger	aWindowMessenger(window);
						BMessage	aMessage(K_GET_FRONTMOST_WINDOW);
						aMessage.AddMessenger("window_messenger", aWindowMessenger);
						BMessenger	aMessenger = msg->ReturnAddress();
						aMessenger.SendMessage(&aMessage);
						break;
					}
					beep();
				}*/
			
			}
			break;
			
		default:
			this->BApplication::MessageReceived(msg);
	}
}


void
KApp::ArgvReceived(int32 argc, char **argv)
{	
	
	if(argc >= 1){
		if(::strncmp(*(argv + 1), "mailto:", 7) == 0){//from System-wide message handling URL's...
			int32		aLen = ::strlen(*(argv + 1));
			char*		aAddress = new char[aLen];
			char*		aText = new char[aLen + 256];
			::strcpy(aAddress, *(argv + 1) + 7);
			::sprintf(aText, "to:%s\nsubj:\n", aAddress);
			int32		aTextLen = ::strlen(aText);
			
			KWindow*	aWindow = this->MakeNewWindow();
			BTextView*	aTextView = dynamic_cast<BTextView*>(aWindow->FindView("textview"));
			aTextView->SetText(aText);
			if(::strlen(aAddress) == 0){
				aTextView->Select(3, 3);
				aWindow->SetTitle("no address");
			}else{
				aTextView->Select(aTextLen - 1, aTextLen - 1);
				aWindow->SetTitle(aAddress);
			}
			aWindow->SetDirty(false);
			aWindow->Show();
			delete[]	aText;
			delete[]	aAddress;
		
		}else{
			BMessage*	aMessage = this->CurrentMessage();
			const char*		aCWD;
			aMessage->FindString("cwd", &aCWD);
			
			BDirectory	aDir(aCWD);
		
			BEntry*	aEntry = new BEntry();
			if(aDir.FindEntry(*(argv + 1), aEntry) != B_NO_ERROR){
				BFile*	aFile = new BFile();
				aDir.CreateFile(*(argv + 1), aFile, false);
				aDir.FindEntry(*(argv + 1), aEntry);
				BNodeInfo	aInfo(aFile);
				aFile->Lock();
				aInfo.SetPreferredApp(kMySignature);
				aInfo.SetType(kTextPlain);
				aFile->Unlock();
				delete aFile;
			}
			BMessage	aOpenMessage(B_REFS_RECEIVED);
			entry_ref	aRef;
			
			aEntry->GetRef(&aRef);
			aOpenMessage.AddRef("refs", &aRef);
			this->RefsReceived(&aOpenMessage);
		}
	}
}


void
KApp::ReadyToRun()
{
	//::printf("ready_to_run\n");
	if(fWindowList.CountItems() == 0){
		this->MakeNewWindow()->Show();
	}
}


void
KApp::RefsReceived(BMessage* msg)
{
	entry_ref	ref;
	type_code	type;
	int32		count;
	msg->GetInfo("refs", &type, &count);
	if(type != B_REF_TYPE)
		return;
	
	//msg->PrintToStream();
	
	BMessenger	aMessenger, *aNewMessenger;
	msg->FindMessenger("TrackerViewToken", 0, &aMessenger);
	
	for(int32 i = 0; i < count; i++){
		msg->FindRef("refs", i, &ref);
		BEntry*		entry = new BEntry(&ref);
		
		const int32	windowNum = fWindowList.CountItems();
		bool	makeNew = true;
		
		for(int32 j = 0; j < windowNum; j++){
			KWindow*	aWindow = (KWindow*)fWindowList.ItemAt(j);
			BEntry*		docEntry = aWindow->GetEntry();
			if(docEntry != NULL){
				entry_ref	docRef;
				docEntry->GetRef(&docRef);
				if(docRef == ref){
					aWindow->Lock();
					if(aMessenger.IsValid()){
						aNewMessenger = new BMessenger(aMessenger);
						aWindow->SetTrackerToken(aNewMessenger);
					}
					aWindow->Activate();
					aWindow->Unlock();
					makeNew = false;
					break;
				}
			}
		}
		
		
		if(makeNew){
			bool	aWillOpen = true;
			if(!this->IsTextFile(entry)){
				char	aFileName[B_FILE_NAME_LENGTH];
				char*	aAlertText = new char[B_FILE_NAME_LENGTH + 512];
				entry->GetName(aFileName);
				::sprintf(aAlertText
							, "This Document isn't a text file.\n"
								"Do you want to open \"%s\" ?"
							, aFileName);		
				BAlert*	aAlert = new BAlert(B_EMPTY_STRING
									, aAlertText
									, "Proceed"
									, "Cancel");
				aAlert->SetShortcut(0, 'p');
				int32	aResult = aAlert->Go();
		
				if(aResult == 0){
					;
				}else if(aResult == 1){
					//::beep();
					delete	entry;
					aWillOpen = false;
				}
				delete[]	aAlertText;
			}
			
			if(aWillOpen){
				KWindow*	aWindow = this->MakeNewWindow(entry);
				aWindow->Lock();
				if(aMessenger.IsValid()){
					aNewMessenger = new BMessenger(aMessenger);
					aWindow->SetTrackerToken(aNewMessenger);
				}
				aWindow->Show();
				aWindow->Unlock();
			}
			
		}
		
	}
}


KWindow*
KApp::MakeNewWindow(BEntry* entry)
{

	const int32	windowNum = fWindowList.CountItems() + 1;
	
	char* name = new char[B_FILE_NAME_LENGTH + 1];
	
	if(entry == NULL){
		::sprintf(name, "%s %d", kDefaultWindowName, (int)windowNum);
	}else{
		entry->GetName(name);
	}
	
	
	BScreen	screen(B_MAIN_SCREEN_ID);
	float	height = screen.Frame().Height() - 100;
	
	BRect	rect(0, 0, 0.85 * height, height);
	rect.OffsetTo(10 * windowNum + 50, 10 * (windowNum % 5) + 50);
	
	KWindow*	window = new KWindow(rect, name, entry);
	fWindowList.AddItem(window);
	
	delete[] name;
	
	return window;
}


void
KApp::ShowPrefsWindow()
{
	if(fPrefsWindow == NULL){
		BScreen	screen(B_MAIN_SCREEN_ID);
		BRect	screenRect = screen.Frame();
		BRect	frame(kPrefsWindowFrame);
		
		frame.OffsetBy(0.5 * (screenRect.Width() - frame.Width())
						,0.5 * (screenRect.Height() - frame.Height() - 50.0));
						
		fPrefsWindow = new KPrefsWindow(frame);
	}
	
	fPrefsWindow->Lock();
	if(fPrefsWindow->IsHidden())
		fPrefsWindow->Show();
		
	fPrefsWindow->Activate();
	fPrefsWindow->Unlock();
}


void
KApp::MakeFindWindow()
{
	BScreen	screen(B_MAIN_SCREEN_ID);
	BRect	aRect(screen.Frame());
	BRect	aFindWindowFrame(kFindWindowFrame);
	
	aFindWindowFrame.OffsetBy(0.5 * (aRect.Width() - aFindWindowFrame.Width())
							,0.5 * (aRect.Height() - aFindWindowFrame.Height() - 50.0));
							
	fFindWindow = new KFindWindow(aFindWindowFrame);
}


bool
KApp::IsTextFile(BEntry* entry)
{
	key_info	aKeyInfo;
	get_key_info(&aKeyInfo);
	if((aKeyInfo.modifiers & B_COMMAND_KEY) != 0)
		return true;
	
	
	bool		aBool = false;
	BFile		file(entry, B_READ_ONLY);
	BNodeInfo	info(&file);
	
	char*		aFileType = new char[B_MIME_TYPE_LENGTH + 1];
	file.Lock();
	info.GetType(aFileType);
	if(strncmp(aFileType, "text", 4) == 0){
		aBool = true;
	}
	delete[]	aFileType;
	file.Unlock();
	return aBool;
}


void
KApp::AboutRequested()
{
	char	aAboutString[256];
	*aAboutString = '\0';
	::strcat(aAboutString, kKEditDescription);
	::strcat(aAboutString, 	"\n"
							"2000 by Karino, Masatsugu\n"
							"\n"
							"All rights reserved.");
	(new BAlert(B_EMPTY_STRING, aAboutString, "OK"))->Go();
}




static	property_info	prop_list[] = {
	{ "Application", {B_GET_PROPERTY, 0}, {B_DIRECT_SPECIFIER, 0}, "application"},
	{ "Window", {B_GET_PROPERTY, 0}, {B_DIRECT_SPECIFIER, B_INDEX_SPECIFIER, B_NAME_SPECIFIER, 0}, "window"},
	{ "TextView", {B_GET_PROPERTY, 0}, {B_DIRECT_SPECIFIER, 0}, "TextView"},
	{}
};


BHandler*
KApp::ResolveSpecifier(BMessage* msg, int32 index
					, BMessage* specifier, int32 form
					, const char* property)
{
	BPropertyInfo	prop_info(prop_list);
	if(prop_info.FindMatch(msg, index, specifier, form, property) >= 0){
		return this;
	}
	
	return this->BApplication::ResolveSpecifier(msg, index, specifier, form, property);	
}

status_t
KApp::GetSupportedSuites(BMessage* msg)
{
	msg->AddString("suites", "suite/vnd.karino-kedit-application");
	BPropertyInfo	prop_info(prop_list);
	msg->AddFlat("messages", &prop_info);
	
	return this->BApplication::GetSupportedSuites(msg);
}














