#include "KDirView.h"

#include <StringView.h>
#include <Entry.h>
#include <Directory.h>
#include <Window.h>
#include <Beep.h>
#include <Message.h>


KDirView::KDirView(BRect frame, const char* name, const char* label)
		:BStringView(frame, name, label), fDirEntry(NULL)
{
	
}

KDirView::~KDirView()
{
	delete	fDirEntry;
}


void
KDirView::MessageReceived(BMessage* msg)
{
	//only Entry(directory) is dropped...
	if(msg->WasDropped()){
		entry_ref	aRef;
		if(msg->FindRef("refs", 0, &aRef) != B_NO_ERROR){ return; }
		BEntry*		aEntry = new BEntry(&aRef);
		if(aEntry->InitCheck() != B_NO_ERROR
			 || !aEntry->IsDirectory()){
			::beep();
			delete	aEntry;
			return;
		}
		char*	aName = NULL;
		aEntry->GetName(aName);
		this->SetText(aName);
		delete	fDirEntry;
		fDirEntry = aEntry;
		
		//msg->MakeEmpty();
		msg->what = K_TARGET_DIR_CHANGED;
		this->Window()->PostMessage(msg);
	}else{
		this->BStringView::MessageReceived(msg);
	}
}



















