#include "KLineNumView.h"

#include <stdio.h>
#include <Window.h>
#include <TextView.h>
#include <Message.h>
#include <Application.h>

#include "KTextUtils.h"
#include "KGoToLineWindow.h"
#include "KMenuBar.h"


KLineNumView::KLineNumView(BRect frame, const char* name)
		:BStringView(frame, name, "dummy"
				, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_PULSE_NEEDED)
{
	fLineNum = 1;
	this->SetFontSize(10);
	
	this->DrawLineNum();
	
}

KLineNumView::~KLineNumView()
{
	
}


void
KLineNumView::MouseDown(BPoint where)
{
	BMessage	aMessage(K_SHOW_GO_TO_LINE_WINDOW);
	aMessage.AddPointer("window", this->Window());
	be_app->PostMessage(&aMessage, NULL);
}


void
KLineNumView::MessageReceived(BMessage* msg)
{
	switch(msg->what){
		
		default:
			this->BStringView::MessageReceived(msg);
	}
}


void
KLineNumView::Pulse()
{
	const BTextView*	textview = (BTextView*)Window()->FindView("textview");
	int32	from, to;
	textview->GetSelection(&from, &to);
	const char* text = textview->Text();
	int32	linenum = 1;
	for(int32 i = 0; i < from; i++){
		if(*(text + i) == LF)
			linenum++;
	}
	if(linenum != fLineNum){
		fLineNum = linenum;
		this->DrawLineNum();
	}
	
	this->BStringView::Pulse();
}


void
KLineNumView::DrawLineNum()
{
	char*	lineChar = new char[100];
	::sprintf(lineChar, "Line %ld", fLineNum);
	this->SetText(lineChar);
}







