#include "KPrefsView.h"

#include <stdio.h>
#include <Box.h>
#include <Button.h>
#include <CheckBox.h>
#include <MenuField.h>
#include <MenuItem.h>
#include <Message.h>
#include <Bitmap.h>
#include <TranslationUtils.h>
#include <Path.h>
#include <FindDirectory.h>
#include <PopUpMenu.h>
#include <Window.h>

#include "KPrefs.h"
#include "KApp.h"
#include "KPrefsFontView.h"
#include "KMenuBar.h"
#include "KShortcut.h"

#include "KRectUtils.h"

KPrefsView::KPrefsView(BRect frame)
		: BView(frame, "prefsview", B_FOLLOW_ALL, B_WILL_DRAW)
{
	this->Initialize();
	this->AddChildren();
	this->LoadPrefs();
}


KPrefsView::~KPrefsView()
{
	delete[] 	fFontFamily;
	delete[]	fFontStyle;
	delete		fBackgroundBitmap;
}


void
KPrefsView::Initialize()
{
	fWordWrap = fAutoIndent = fMemorizeWindow = fAutoDetectFileType = false;
	fFontFamily = new char[B_FONT_FAMILY_LENGTH + 1];
	fFontStyle = new char[B_FONT_STYLE_LENGTH + 1];
	fSize = 12;
	fTabWidth = 28;
	fKeyAssign = 0;
	fMultiButton = 0;
	fBackgroundBitmap = NULL;
}


void
KPrefsView::AttachedToWindow()
{	
	const rgb_color	viewcolor	= ::ui_color(B_PANEL_BACKGROUND_COLOR);//{240, 240, 240};
	this->SetViewColor(viewcolor);
	
	BBitmap*	aBitmap;
	BPath		aPath;
	::find_directory(B_USER_SETTINGS_DIRECTORY, &aPath, true);
	aPath.Append(kSettingDir);
	aPath.Append(kBackgroundFolder);
	aPath.Append(kBackgroundImageName);
	
	aBitmap = BTranslationUtils::GetBitmap(aPath.Path(), NULL);
	
	if(aBitmap != NULL){
		if(aBitmap->ColorSpace() == B_RGB32){//only for 32-bit color graphics.
			int32	aLength = aBitmap->BitsLength();
			uchar*	aData = (uchar*)aBitmap->Bits();
			for(int32 i = 0; i < aLength; i++){
				*(aData + i) += (255 - *(aData + i))/3;
			}
		}
		
		this->SetViewBitmap(aBitmap);
		
		fBackgroundBitmap = aBitmap;
		
		int32	aCount = this->CountChildren();
		BView*	aView = NULL;
		for(int32 i = 0; i < aCount; i++){
			if((aView = dynamic_cast<BView*>(this->ChildAt(i))) != NULL){
				//BPoint	where(aView->Frame().LeftTop());
				BRect	aViewFrame(aView->Frame());
				BRect	aDestFrame(aViewFrame);
				aDestFrame.OffsetTo(B_ORIGIN);
				
				aView->SetViewBitmap(aBitmap, aViewFrame, aDestFrame);
			}
		}
	}else{
		
	}
	
}


void
KPrefsView::AddChildren()
{
	//KRectUtils	utils;
	BRect	aViewRect(this->Bounds());
	
	////////////////////
	// Add Buttons
	////////////////////
	BRect	aButtonFrame(0, 0, 65, 25);
	aButtonFrame.OffsetBy(aViewRect.Width() - 80, aViewRect.Height() - 40);
	
	BButton*	aOKButton = new BButton(aButtonFrame,"ok_button","Set"
							, new BMessage(K_OK_BUTTON_PRESSED));
	this->AddChild(aOKButton);
	aOKButton->MakeDefault(true);
	aOKButton->SetFont(be_bold_font, B_FONT_ALL);
							
	aButtonFrame.OffsetBy(-80, 0);
	
	BButton*	aCancelButton = new BButton(aButtonFrame, "cancel_button", "Cancel"
								, new BMessage(K_CANCEL_BUTTON_PRESSED));
	this->AddChild(aCancelButton);
	aCancelButton->SetFont(be_bold_font, B_FONT_ALL);
	
	

	////////////////////
	// Add CheckBoxes
	////////////////////
	BRect	frame(0,0,250,20);
	
	frame.OffsetBy(10, 120);
	
	BCheckBox*	aCheckBox = new BCheckBox(frame, "word_wrap", "Word Wrap....................................................................................................................", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 20);
	
	aCheckBox = new BCheckBox(frame, "auto_indent", "Auto Indent", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 20);
	
	aCheckBox = new BCheckBox(frame, "memorize_window_rect", "Memorize Window Status", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 30);
	
	aCheckBox = new BCheckBox(frame, "multi_button_function", "Use 2nd and 3rd button to copy / paste", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 20);
	
	aCheckBox = new BCheckBox(frame, "auto_detect_filetype", "Auto-detection of the file type", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 20);
	
	aCheckBox = new BCheckBox(frame, "reset_filetype_and_preferredapp", "Reset \"file type & preferred app\" on saving", NULL);
	this->AddChild(aCheckBox);
	
	frame.OffsetBy(0, 20);
	
	aCheckBox = new BCheckBox(frame, "browser_always_makes_new_window", "Browser always makes a new window", NULL);
	this->AddChild(aCheckBox);

	////////////////////
	// Add Box and StringView
	////////////////////
	
	frame.Set(0,0,350,40);
	
	frame.OffsetBy(10, 10);
	
	BBox*	aBox = new BBox(frame, "font_box");
	aBox->SetLabel("Font");
	this->AddChild(aBox);
	
	frame.Set(0, 0, 220, 20);
	frame.OffsetBy(10, 15);
	
	KPrefsFontView*	aStringView = new KPrefsFontView(frame, "font_stringview");
	aStringView->SetFont(be_bold_font);
	aBox->AddChild(aStringView);

	////////////////////
	// Add PopupMenus
	////////////////////
	char	aSizeText[16];
	frame.OffsetBy(frame.Width() + 10, -2);
	frame.right = frame.left + 70;
	
	BPopUpMenu*		aMenu = new BPopUpMenu("");
	aMenu->SetRadioMode(true);

	for(int32 i = 0; i < 9; i++){
		sprintf(aSizeText, "%d", kFontSizeSet[i]);
		BMessage*	aMessage = new BMessage(K_SIZE);
		aMessage->AddFloat("font_size", kFontSizeSet[i]);
		BMenuItem*	aMenuItem = new BMenuItem(aSizeText, aMessage);
		aMenuItem->SetTarget(this);
		aMenu->AddItem(aMenuItem);
	}
	
	BMenuField*	aMenuField = new BMenuField(frame, "size_menufield", "Size : ", aMenu);
	aMenuField->SetFont(be_bold_font);
	aBox->AddChild(aMenuField);
	
	
	//tab.
	frame.Set(0, 0, 200, 20);
	frame.OffsetBy(20, 60);
	
	aMenu = new BPopUpMenu("");
	aMenu->SetRadioMode(true);
	char	tabWidth[16];
	
	for(int32 i = 1; i <= 15; i++){
		::sprintf(tabWidth, "%ld", 7 * i);
		BMessage*	aMessage = new BMessage(K_TAB_WIDTH);
		aMessage->AddFloat("tab_width", (float)7 * i);
		BMenuItem*	aMenuItem = new BMenuItem(tabWidth, aMessage);
		aMenuItem->SetTarget(this);
		aMenu->AddItem(aMenuItem);
	}
	
	aMenuField = new BMenuField(frame, "tab_menufield", "Tab Width : ", aMenu);
	aMenuField->SetFont(be_bold_font);
	this->AddChild(aMenuField);
	
	//Key Assign
	frame.OffsetBy(0, 30);
	frame.right = frame.left + 200;
	
	aMenu = new BPopUpMenu("");
	aMenu->SetRadioMode(true);
	
	BMessage*	aMessage = new BMessage(K_KEY_ASSIGN);
	aMessage->AddInt32("key_assign", K_KEDIT_KEY_ASSIGN);
	BMenuItem*	aMenuItem = new BMenuItem("KEdit Original", aMessage);
	aMenu->AddItem(aMenuItem);
	
	aMessage = new BMessage(K_KEY_ASSIGN);
	aMessage->AddInt32("key_assign", K_EMACS_KEY_ASSIGN);
	aMenuItem = new BMenuItem("Emacs - like", aMessage);
	aMenu->AddItem(aMenuItem);
	
	aMessage = new BMessage(K_KEY_ASSIGN);
	aMessage->AddInt32("key_assign", K_VI_KEY_ASSIGN);
	aMenuItem = new BMenuItem("vi - like", aMessage);
	aMenu->AddItem(aMenuItem);
	
	aMenuField = new BMenuField(frame, "key_assign", "Key Assign : ", aMenu);
	aMenuField->SetFont(be_bold_font);
	this->AddChild(aMenuField);
	
	
	
}


void
KPrefsView::LoadPrefs()
{
	KPrefs*	prefs = ((KApp*)be_app)->GetPrefs();
	const char*	family;
	const char*	style;
	float	size, tabwidth;
	bool	autoindent, wordwrap, memorizewindow, autodetectfiletype, resetfiletype, alwaysmakesnewwindow;
	int32	multibutton, keyassign;
	
	prefs->Lock();
	prefs->GetData("font_family", &family);
	prefs->GetData("font_style", &style);
	prefs->GetData("font_size", &size);
	prefs->GetData("tab_width", &tabwidth);
	prefs->GetData("auto_indent", &autoindent);
	prefs->GetData("word_wrap", &wordwrap);
	prefs->GetData("memorize_window_rect", &memorizewindow);
	prefs->GetData("multi_button", &multibutton);
	prefs->GetData("auto_detect_filetype", &autodetectfiletype);
	prefs->GetData("key_assign", &keyassign);
	prefs->GetData("reset_filetype_and_preferredapp", &resetfiletype);
	prefs->GetData("browser_always_makes_new_window", &alwaysmakesnewwindow);
	prefs->Unlock();
	
	//font
	strcpy(fFontFamily, family);
	strcpy(fFontStyle, style);
	
	char*	aFontString = new char[B_FONT_FAMILY_LENGTH + B_FONT_STYLE_LENGTH + 50];
	sprintf(aFontString, "%s ... %s........................................................................................", fFontFamily, fFontStyle);
	((BStringView*)this->FindView("font_stringview"))->SetText(aFontString);
	
	delete[] aFontString;
	
	fSize = size;
	fTabWidth = tabwidth;
	fAutoIndent = autoindent;
	fWordWrap = wordwrap;
	fMemorizeWindow = memorizewindow;
	fMultiButton = multibutton;
	fAutoDetectFileType = autodetectfiletype;
	fKeyAssign = keyassign;
	fResetFileType = resetfiletype;
	fBrowserAlwaysMakesNewWindow = alwaysmakesnewwindow;
	
	
	//size.
	BMenuField*	aField = (BMenuField*)this->FindView("size_menufield");
	BMenu*		aMenu = aField->Menu();
	for(int32 i = 0; i < 9; i++){
		if(kFontSizeSet[i] == fSize){
			((BMenuItem*)aMenu->ItemAt(i))->SetMarked(true);
		}
	}
	
	//tab.
	aField = (BMenuField*)this->FindView("tab_menufield");
	aMenu = aField->Menu();
	for(int32 i = 0; i < 15; i++){
		if(fTabWidth == 7 * (i + 1)){
			((BMenuItem*)aMenu->ItemAt(i))->SetMarked(true);
		}
	}
	
	//key.
	aField = (BMenuField*)this->FindView("key_assign");
	aMenu = aField->Menu();
	((BMenuItem*)aMenu->ItemAt(fKeyAssign))->SetMarked(true);
	
	//checkboxes.
	((BCheckBox*)this->FindView("auto_indent"))->SetValue(fAutoIndent);
	((BCheckBox*)this->FindView("word_wrap"))->SetValue(fWordWrap);
	((BCheckBox*)this->FindView("memorize_window_rect"))->SetValue(fMemorizeWindow);
	((BCheckBox*)this->FindView("multi_button_function"))->SetValue(fMultiButton);
	((BCheckBox*)this->FindView("auto_detect_filetype"))->SetValue(fAutoDetectFileType);
	((BCheckBox*)this->FindView("reset_filetype_and_preferredapp"))->SetValue(fResetFileType);
	((BCheckBox*)this->FindView("browser_always_makes_new_window"))->SetValue(fBrowserAlwaysMakesNewWindow);
	
}


void
KPrefsView::StorePrefs()
{
	KPrefs*	prefs = ((KApp*)be_app)->GetPrefs();
	
	fAutoIndent = ((BCheckBox*)this->FindView("auto_indent"))->Value();
	fWordWrap = ((BCheckBox*)this->FindView("word_wrap"))->Value();
	fMemorizeWindow = ((BCheckBox*)this->FindView("memorize_window_rect"))->Value();
	fMultiButton = ((BCheckBox*)this->FindView("multi_button_function"))->Value();
	fAutoDetectFileType = ((BCheckBox*)this->FindView("auto_detect_filetype"))->Value();
	fResetFileType = ((BCheckBox*)this->FindView("reset_filetype_and_preferredapp"))->Value();
	fBrowserAlwaysMakesNewWindow = ((BCheckBox*)this->FindView("browser_always_makes_new_window"))->Value();
	
	prefs->Lock();
	prefs->SetData("font_family", fFontFamily);
	prefs->SetData("font_style", fFontStyle);
	prefs->SetData("font_size", fSize);
	prefs->SetData("tab_width", fTabWidth);
	prefs->SetData("auto_indent", fAutoIndent);
	prefs->SetData("word_wrap", fWordWrap);
	prefs->SetData("memorize_window_rect", fMemorizeWindow);
	prefs->SetData("multi_button", fMultiButton);
	prefs->SetData("auto_detect_filetype", fAutoDetectFileType);
	prefs->SetData("key_assign", fKeyAssign);
	prefs->SetData("reset_filetype_and_preferredapp", fResetFileType);
	prefs->SetData("browser_always_makes_new_window", fBrowserAlwaysMakesNewWindow);
	prefs->Unlock();
}


void
KPrefsView::MessageReceived(BMessage* msg)
{
	switch(msg->what)
	{
		case K_STYLE:
			const char	*family, *style;
			msg->FindString("font_family", &family);
			msg->FindString("font_style", &style);
			strcpy(fFontFamily, family);
			strcpy(fFontStyle, style);
			break;
			
		case K_SIZE:
			float	size;
			msg->FindFloat("font_size", &size);
			fSize = size;
			break;
			
		case K_TAB_WIDTH:
			float	tabWidth;
			msg->FindFloat("tab_width", &tabWidth);
			fTabWidth = tabWidth;
			break;
			
		case K_KEY_ASSIGN:
			int32	keyAssign;
			msg->FindInt32("key_assign", &keyAssign);
			fKeyAssign = keyAssign;
			break;
			
		default:
			this->BView::MessageReceived(msg);
	}
}


void
KPrefsView::KeyDown(const char* bytes, int32 numBytes)
{
	if(*bytes == B_ESCAPE && numBytes == 1){
		BPoint	point(0, 0);
		((BButton*)this->FindView("cancel_button"))->MouseDown(point);
		this->Window()->PostMessage(K_CANCEL_BUTTON_PRESSED);
	}
}


void
KPrefsView::Draw(BRect updateRect)
{
	
	this->BView::Draw(updateRect);
	
}












