#include "KPrefsWindow.h"

#include <Message.h>

#include "KMenuBar.h"
#include "KPrefsView.h"


KPrefsWindow::KPrefsWindow(BRect frame)
		: BWindow(frame, "Preference", B_TITLED_WINDOW
					, B_NOT_ZOOMABLE | B_NOT_RESIZABLE | B_ASYNCHRONOUS_CONTROLS)
{
	KPrefsView*	prefsView = new KPrefsView(this->Bounds());
	
	this->AddChild(prefsView);
	prefsView->MakeFocus();
	
	this->AddShortcut('W', 0, new BMessage(K_CANCEL_BUTTON_PRESSED));
}


void
KPrefsWindow::MessageReceived(BMessage* msg)
{
	KPrefsView*	prefsView = (KPrefsView*)this->FindView("prefsview");
	
	switch(msg->what)
	{
		case K_OK_BUTTON_PRESSED:
			this->Hide();
			prefsView->StorePrefs();
			break;
			
		case K_CANCEL_BUTTON_PRESSED:
			this->Hide();
			prefsView->LoadPrefs();
			break;
			
		case K_SIZE:
		case K_TAB_WIDTH:
		case K_KEY_ASSIGN:
			prefsView->MessageReceived(msg);
			break;
			
		default:
			this->BWindow::MessageReceived(msg);
	}
}

bool
KPrefsWindow::QuitRequested()
{
	if(dynamic_cast<BMessage*>(this->CurrentMessage())){
		this->Hide();
		return false;
	}
	return true;
}






















