#include "KShortcut.h"

#include <Clipboard.h>
#include <Window.h>

#include "KTextView.h"
#include "KPrefs.h"
#include "KApp.h"
#include "KMenuBar.h"

#include "KTViewUtils.h"
#include "KTextUtils.h"
#include "KString.h"


KShortcut::KShortcut(KTextView* textview):fTextView(textview)
{
	KPrefs*	prefs = ((KApp*)be_app)->GetPrefs();
	
	int32	keyassign;
	prefs->Lock();
	prefs->GetData("key_assign", &keyassign);
	prefs->Unlock();
	
	this->SetKeyAssign(keyassign);
	
	fPrevKey = 0;
	fPrevModifiers = 0;
}


KShortcut::~KShortcut()
{
	
}


bool
KShortcut::DoShortcut(int32 aRawChar, uint32 aModifiers)
{	
	bool	result = false;
	
	//for READ ONLY document
	if(!fTextView->IsEditable()){
		KTViewUtils	utils(fTextView);
		if(aRawChar == ' ' || aRawChar == B_PAGE_DOWN){
			utils.PageDown();
			return true;
		}else if(aRawChar == B_PAGE_UP){
			utils.PageUp();
			return true;
		}
	}
	
	switch(this->KeyAssign())
	{
		case K_KEDIT_KEY_ASSIGN:
			result = this->DoKEdit(aRawChar, aModifiers);
			break;
		case K_EMACS_KEY_ASSIGN:
			result = this->DoEmacs(aRawChar, aModifiers);
			break;
		case K_VI_KEY_ASSIGN:
			result = this->DoVI(aRawChar, aModifiers);
			break;
		default:
			;
	}
	
	fPrevKey = aRawChar;
	fPrevModifiers = aModifiers;
	
	return result;
}


bool
KShortcut::DoKEdit(int32 aRawChar, uint32 aModifiers)
{
	KTViewUtils	utils(fTextView);
	bool	result = true;
	
	//printf("raw = %d, mod = %x\n", aRawChar, (int32)aModifiers);
	if((aModifiers & B_CONTROL_KEY) != 0){
		switch(aRawChar)
		{
			case 'a':
				if((aModifiers & B_SHIFT_KEY) != 0)
					utils.SelectToLineTop();
				else
					utils.ShowLineTop();
				break;
				
			case 's':
				if((aModifiers & B_SHIFT_KEY) != 0)
					utils.SelectPrevCharacter();
				else
					utils.MoveToLeft();
				break;
				
			case 'd':
				if((aModifiers & B_SHIFT_KEY) != 0)
					utils.SelectNextCharacter();
				else
					utils.MoveToRight();
				break;
				
			case 'f':
				if((aModifiers & B_SHIFT_KEY) != 0)
					utils.SelectToLineBottom();
				else
					utils.ShowLineBottom();
				break;
				
			case 'e':
				utils.MoveToUpperLine();
				break;
				
			case 'x':
				utils.MoveToLowerLine();
				break;
				
			case 'r':
				if(fPrevKey == 'q' && (fPrevModifiers & B_CONTROL_KEY) != 0)
					utils.ShowTop();
				else
					utils.PageUp();
				break;
				
			case 'c':
				if(fPrevKey == 'q' && (fPrevModifiers & B_CONTROL_KEY) != 0)
					utils.ShowBottom();
				else
					utils.PageDown();
				break;
				
			case 'h':
				result = false;
				break;
				
			case 'g':
				utils.DeleteNextCharacter();
				break;
				
			case 'y':
				utils.DeleteLine();
				break;
				
			case 'i':
				fTextView->Insert("\t");
				break;
				
			case 'm':
				fTextView->Insert("\n");
				break;
				
			case 'u':
				{
					int32	from, to;
					fTextView->GetSelection(&from, &to);
					if(from == to){
						utils.SelectCurrentWord();
					}
					utils.SelectionToUpperCase();
				}
				break;
				
			case 'l':
				{
					int32	from, to;
					fTextView->GetSelection(&from, &to);
					if(from == to){
						utils.SelectCurrentWord();
					}
					utils.SelectionToLowerCase();
				}
				break;
				
			case 'p'://test key...
				{
					
					
				}
				break;
			
			default:
				;
		}
	}else if(aRawChar == B_ESCAPE){
		//do nothing
	}else{
		result = false;
	}
		
	return result;
}


bool
KShortcut::DoEmacs(int32 aRawChar, uint32 aModifiers)
{
	KTViewUtils	utils(fTextView);
	bool	result = true;
	if((aModifiers & B_CONTROL_KEY) != 0){
		switch(aRawChar)
		{
			case 'p':
				utils.MoveToUpperLine();
				break;
			case 'n':
				utils.MoveToLowerLine();
				break;
			case 'b':
				utils.MoveToLeft();
				break;
			case 'f':
				utils.MoveToRight();
				break;
			case 'a':
				utils.ShowLineTop();
				break;
			case 'e':
				utils.ShowLineBottom();
				break;
			case 'r':
				utils.ShowTop();
				break;
			case 'c':
				utils.ShowBottom();
				break;
			case 'v':
				utils.PageDown();
				break;
			case 'h':
				result = false;
				break;
			case 'd':
				utils.DeleteNextCharacter();
				break;
			case 'k':
				utils.SelectToLineBottom();
				fTextView->Delete();
				break;
			case 'i':
				fTextView->Insert("\t");
				break;
			case 'm':
				fTextView->Insert("\n");
				break;
			case 'w':
				fTextView->Cut(be_clipboard);
				break;
			case 'y':
				fTextView->Paste(be_clipboard);
				break;
			case 's':
				if(fPrevKey == 'x' && (fPrevModifiers & B_CONTROL_KEY) != 0)
					fTextView->Window()->PostMessage(K_SAVE);
				break;
			
			default:
				;
		}
	}else if(fPrevKey == B_ESCAPE){
		switch(aRawChar)
		{
			case 'd':
				utils.DeleteWord();
				break;
			case 'w':
				fTextView->Copy(be_clipboard);
				break;
			case 'v':
				utils.PageUp();
				break;
			case 'u':
				utils.SelectionToUpperCase();
				break;
			case 'l':
				utils.SelectionToLowerCase();
				break;
			default:
				;
		}
	}else if(aRawChar == B_ESCAPE){
		
	}else{
		result = false;
	}
	return result;
}


bool
KShortcut::DoVI(int32 aRawChar, uint32 aModifiers)
{
	KTViewUtils	utils(fTextView);
	bool	result = true;
	if((aModifiers & B_CONTROL_KEY) != 0){
		switch(aRawChar)
		{
			case 'k':
				utils.MoveToUpperLine();
				break;
			case 'j':
				utils.MoveToLowerLine();
				break;
			case 'h':
				utils.MoveToLeft();
				break;
			case 'l':
				utils.MoveToRight();
				break;
			case 'x':
				utils.DeletePrevCharacter();
				break;
			case 'u':
				fTextView->Undo(be_clipboard);
				break;
		}
	}else{
		result = false;
	}
	
	return result;
}























