#ifndef __KTViewUtils_h__
#define __KTViewUtils_h__

#include <SupportDefs.h>

class BTextView;

class KTViewUtils
{
	public:
		KTViewUtils(BTextView* textview, bool smooth = false);
		~KTViewUtils();
		
		void	ShowTop();
		void	ShowBottom();
		void	ShowLineTop();
		void	ShowLineBottom();
		
		void	MoveToUpperLine();
		void	MoveToLowerLine();
		void	MoveToRight();
		void	MoveToLeft();
		
		void	SelectNextCharacter();
		void	SelectPrevCharacter();
		void	SelectToLineTop();
		void	SelectToLineBottom();
		void	SelectCurrentWord();
		
		void	DeleteNextCharacter();
		void	DeletePrevCharacter();
		void	DeleteLine();
		void	DeleteWord();
		
		void	SelectionToUpperCase();
		void	SelectionToLowerCase();
		
		void	PageUp();
		void	PageDown();
	
		void		SetTextView(BTextView* textview){ fTextView = textview; }
		BTextView*	TextView()const{ return fTextView; }
	
	private:
		static status_t		do_scroll_up(void* arg);
		static status_t		do_scroll_down(void* arg);
		
		BTextView*	fTextView;
		
		bool		fSmoothScroll;
};

#endif