#include "KView.h"

#include <ScrollBar.h>

#include "KWindow.h"
#include "KBottomView.h"
#include "KTextView.h"

KView::KView(BRect frame, const char* name)
	:BView(frame, name, B_FOLLOW_ALL, B_WILL_DRAW|B_PULSE_NEEDED)
{
	frame.OffsetTo(B_ORIGIN);
	
	BRect	textFrame(frame);
	
	//textFrame.top += 1;
	textFrame.right -= B_V_SCROLL_BAR_WIDTH;
	textFrame.bottom -= B_H_SCROLL_BAR_HEIGHT;
	
	BRect	textRect(textFrame);
	
	textRect.top += 2;
	textRect.left += 2;
	KTextView*	textview = new KTextView(textFrame, "textview", textRect
											, B_FOLLOW_ALL, B_WILL_DRAW);
	
	this->AddChild(textview);
	
	
	//scroll bar.
	BRect	scrollRect(frame);
	scrollRect.left = textFrame.Width() + 1;
	scrollRect.bottom -= B_H_SCROLL_BAR_HEIGHT - 1;
	scrollRect.right += 2;
	
	BScrollBar*	vScroll = new BScrollBar(scrollRect, "vscroll"
								, textview, 0, textFrame.Height(), B_VERTICAL);
	
	this->AddChild(vScroll);
	
	//scroll bar.
	const int32	bottomViewWidth = 180;
	
	scrollRect = frame;
	//scrollRect.top = textFrame.Height() + 1;
	scrollRect.top = frame.bottom - B_H_SCROLL_BAR_HEIGHT + 1;
	scrollRect.right -= B_V_SCROLL_BAR_WIDTH - 1;
	scrollRect.bottom += 2;
	
	scrollRect.left += bottomViewWidth + 1;
	
	BScrollBar*	hScroll = new BScrollBar(scrollRect, "hscroll"
								, textview, 0, textFrame.Width(), B_HORIZONTAL);
								
	this->AddChild(hScroll);
	
	
	
	//Bottom view.
	scrollRect.left = 0;
	scrollRect.right = bottomViewWidth;
	
	KBottomView*	bottomView = new KBottomView(scrollRect);
	
	this->AddChild(bottomView);
}





void
KView::MessageReceived(BMessage* msg)
{
	this->BView::MessageReceived(msg);
}


void
KView::AttachedToWindow()
{
	//const rgb_color	viewcolor	= {235, 235, 235};
	const rgb_color	highcolor	= {0, 255, 0};
	//const rgb_color	lowcolor	= {0, 0, 0};
	
	this->SetViewColor(highcolor);
	this->SetHighColor(highcolor);
}

void
KView::Draw(BRect rect)
{
	//BRect	frame(this->Bounds());
	//this->StrokeRect(frame, B_SOLID_HIGH);
	this->BView::Draw(rect);
}

void
KView::Pulse()
{
	
	this->BView::Pulse();
}


















