#include "radeon_accelerant.h"

#include "pll_regs.h"
#include "../common/utils.h"
#include <stdio.h>

int main()
{
	general_pll_info general_pll;
	pll_info pll;
	pll_dividers values;

	general_pll.max_pll_freq = 35000;
	general_pll.min_pll_freq = 20000;
	general_pll.xclk = 10;
	general_pll.ref_div = 12;
	general_pll.ref_freq = 2700;
	
	Radeon_GetTVPLLConfiguration( &general_pll, &pll, true );
	
	Radeon_CalcPLLDividers( &pll, 42954540, 0, &values );
		
	printf( "dot_clock_freq=%ld, ref_div=%ld, feedback_div=%ld, post_div=%ld",
		values.freq, 
		values.ref, values.feedback, values.post );
		
	return 0;
}
