#include "memmgr.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>

int main( int argc, char **argv )
{
	mem_info *mem;
	uint32 blocks[512];
	void *tag;
	int i, j;
	
	(void)argc;
	(void)argv;
	
	mem = mem_init( 0x100000, 0x200000, 0x1000, 0x200000 / 0x1000 );
	
	memset( blocks, 0, sizeof( blocks ));
	tag = (void *)1234;
	
	for( i = 0; i < 4096*10; ++i ) {
		j = rand() % 512;
		
		if( blocks[j] ) {
			if( mem_free( mem, blocks[j], tag ) != B_OK )
				printf( "Ouch!\n" );
			blocks[j] = 0;
		} else {
			uint32 offset;
			status_t res;
			
			res = mem_alloc( mem, rand() % 0x100000, tag, &blocks[j], &offset );
			
			if( res != B_OK && res != B_NO_MEMORY )
				printf( "Ups\n" );
			else
				printf( "." );
		}
	}
	
	for( i = 0; i < 512; ++i ) {
		if( blocks[i] )
			mem_free( mem, blocks[i], tag );
	}
		
	mem_destroy( mem );
	
	printf( "Passed\n" );
	
	return 0;
}
