/*
	Copyright (c) 2002, Thomas Kurschel
	based on Screen Preferences Panel written for OpenBeOS by Rafael Romo


	Part of Radeon Screen Preferences
		
	Main window, handling mode select and set
*/

#ifndef SCREENWINDOW_H
#define SCREENWINDOW_H

#include <PopUpMenu.h>
#include <MenuField.h>
#include <Window.h>
#include <Screen.h>
#include <Box.h>

#include "ScreenDrawView.h"
#include "RefreshWindow.h"
#include "ScreenSettings.h"

// multi-monitor combine modes
typedef enum {
	cb_disable,
	cb_horizontally,
	cb_vertically
} CombineMode;

class ScreenWindow : public BWindow
{

public:
						ScreenWindow(ScreenSettings *Settings);
	virtual				~ScreenWindow();
	virtual	bool		QuitRequested();
	virtual void 		MessageReceived(BMessage *message);
	virtual void		WorkspaceActivated(int32 ws, bool state);
	virtual void 		FrameMoved(BPoint position);
	virtual void		ScreenChanged(BRect frame, color_space mode);

private:
	void				CheckApplyEnabled();
	ScreenSettings		*fSettings;
	ScreenDrawView		*fScreenDrawView;
	RefreshWindow		*fRefreshWindow;
	BPopUpMenu			*fWorkspaceMenu;
	BMenuField			*fWorkspaceField;
	BPopUpMenu			*fWorkspaceCountMenu;
	BMenuField			*fWorkspaceCountField;
	BPopUpMenu			*fResolutionMenu;
	BMenuField			*fResolutionField;
	BPopUpMenu			*fColorsMenu;
	BMenuField			*fColorsField;
	BPopUpMenu			*fRefreshMenu;
	BMenuField			*fRefreshField;
	BPopUpMenu			*fCombineMenu;
	BPopUpMenu			*fSwapDisplaysMenu;
	BPopUpMenu			*fUseLaptopPanelMenu;
	BPopUpMenu			*fTVStandardMenu;
	BMenuItem			*fOtherRefresh;
	BMenuItem			*fCurrentWorkspaceItem;
	BMenuItem			*fAllWorkspacesItem;
	BButton				*fDefaultsButton;
	BButton				*fApplyButton;
	BButton				*fRevertButton;
	BBox				*fScreenBox;
	BBox 				*fControlsBox;
	
	display_mode		*fModeList;
	uint32				fModeListCount;
	
	display_mode		fOrigMode;
	bool				fOrigSwapDisplays;
	bool				fOrigUseLaptopPanel;
	uint32				fOrigTVStandard;
	
	display_mode		fActiveMode;
	uint16				fActiveWidth;
	uint16				fActiveHeight;
	int16				fActiveRefresh10;
	int32				fActiveBpp;
	uint32				fActiveSpace;
	CombineMode			fActiveCombineMode;
	bool				fActiveSwapDisplays;
	bool				fActiveUseLaptopPanel;
	uint32				fActiveTVStandard;

	int32				fSelectedWidth;
	int32				fSelectedHeight;
	int32				fSelectedRefresh10;
	int32				fSelectedBpp;
	uint32				fSelectedSpace;
	CombineMode			fSelectedCombineMode;
	bool				fSelectedSwapDisplays;
	bool				fSelectedUseLaptopPanel;
	uint32				fSelectedTVStandard;
	
	bool				fChangingAllWorkspaces;
	
	void				ReflectActiveMode();
	void				UpdateResolutions( CombineMode combine );
	void				UpdateModeOptions( int width, int height, CombineMode combine );
	void				ReflectSelectedRefresh();
	bool				canApply();
	bool				canRevert();
	bool				getSelectedMode( display_mode *mode );
	void				Apply();
	BString				Refresh2Text( int refresh10, bool always_with_fraction );
	void				ReflectSelectedResolution();

public:	
	static int			getModeRefresh10( display_mode *mode );
};

#endif
