/*
	Copyright (c) 2002, Thomas Kurschel
	based on Screen Preferences Panel written for OpenBeOS by Rafael Romo


	Part of Radeon Screen Preferences
		
	Window for user-selected refresh rate
*/

#include <Locker.h>
#include <Window.h>
#include <String.h>
#include <Button.h>

#include <Alert.h>

#include "RefreshWindow.h"
#include "RefreshView.h"
#include "RefreshSlider.h"
#include "Constants.h"

RefreshWindow::RefreshWindow(BWindow *screenWindow, BRect frame, int32 refresh10)
	: BWindow(frame, "Refresh Rate", B_MODAL_WINDOW, 
			  B_NOT_RESIZABLE | B_NOT_ZOOMABLE, B_ALL_WORKSPACES),
	  fScreenWindow( screenWindow )
{
	frame = Bounds();
	
	fRefreshView = new RefreshView(frame, "RefreshView");
	
	AddChild(fRefreshView);
	
	BRect SliderRect;
	
	SliderRect.Set(10.0, 35.0, 299.0, 60.0);
	
	fRefreshSlider = new RefreshSlider(SliderRect);
	
	fRefreshSlider->SetHashMarks(B_HASH_MARKS_BOTTOM);
	fRefreshSlider->SetHashMarkCount(10);
	fRefreshSlider->SetLimitLabels("48.0", "90.0");
	fRefreshSlider->SetKeyIncrementValue(1);
	fRefreshSlider->SetValue(refresh10);
	fRefreshSlider->SetSnoozeAmount(1);
	fRefreshSlider->SetModificationMessage(new BMessage(SLIDER_MODIFICATION_MSG));
	
	fRefreshView->AddChild(fRefreshSlider);
	
	BRect ButtonRect;
	
	ButtonRect.Set(219.0, 97.0, 230.0, 120.0);
	
	fDoneButton = new BButton(ButtonRect, "DoneButton", "Done", 
	new BMessage(BUTTON_DONE_MSG));
	
	fDoneButton->ResizeToPreferred();
	fDoneButton->MakeDefault(true);
	
	fRefreshView->AddChild(fDoneButton);
	
	ButtonRect.Set(130.0, 97.0, 200.0, 120.0);
	
	fCancelButton = new BButton(ButtonRect, "CancelButton", "Cancel", 
	new BMessage(BUTTON_CANCEL_MSG));
	
	fCancelButton->ResizeToPreferred();
	
	fRefreshView->AddChild(fCancelButton);
	
	Show();
	
	PostMessage(SLIDER_INVOKE_MSG);
}

bool RefreshWindow::QuitRequested()
{
	return(true);
}

void RefreshWindow::WindowActivated(bool active)
{
	if (active == true)
		fRefreshSlider->MakeFocus(true);
	else
		fRefreshSlider->MakeFocus(false);
}

void RefreshWindow::MessageReceived(BMessage* message)
{
	switch(message->what)
	{
		case BUTTON_DONE_MSG:
		{
			//BMessenger Messenger("application/x-vnd.RR-SCRN");
	
			BMessage Message(SET_CUSTOM_REFRESH_MSG);
			
			Message.AddInt32("refresh10", fRefreshSlider->Value() );
			
			//Messenger.SendMessage(&Message);
			fScreenWindow->PostMessage( &Message );
			
			PostMessage(B_QUIT_REQUESTED);
			
			break;
		}
	
		case BUTTON_CANCEL_MSG:
		{
			PostMessage(B_QUIT_REQUESTED);
			
			break;
		}
		
		case SLIDER_INVOKE_MSG:
		{
			fRefreshSlider->MakeFocus(true);
			
			break;
		}
	
		default:
			BWindow::MessageReceived(message);
		
			break;
	}
}
