
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <stdio.h>
#include "parport.h"
#include "ppa_lowlevel.h"
#include "scsi_ppa.h"


// User level test program that tests interaction with lowlevel io routines
// NOTE: requires the IOPORT driver to run (see BeWare)


/*----------------------------------------------------------*/

int main()
	{
	char* p;
	struct parport* pb = NULL;
	InquiryData data;

	p = (unsigned char*)malloc(512);
	memset(p,0,512);

	if(parport_init())
		{
		pb = parport_getport(0);
		
		printf("SPP support:    %s\n",pb->modes & PARPORT_MODE_PCSPP ? "Yes" : "No");	
		printf("ECR present:    %s\n",pb->modes & PARPORT_MODE_PCECR ? "Yes" : "No");	
		printf("ECP support:    %s\n",pb->modes & PARPORT_MODE_PCECP ? "Yes" : "No");	
		printf("EPP support:    %s\n",pb->modes & PARPORT_MODE_PCEPP ? "Yes" : "No");	
		printf("ECPEPP support: %s\n",pb->modes & PARPORT_MODE_PCECPEPP ? "Yes" : "No");	
		printf("PS2 support:    %s\n",pb->modes & PARPORT_MODE_PCPS2 ? "Yes" : "No");	
		printf("ECPPS2 support: %s\n",pb->modes & PARPORT_MODE_PCECPPS2 ? "Yes" : "No");	

		parport_claimport(pb);
		printf("ppa_init() returned %d\n",(int)ppa_init(pb));
		printf("TestUnitReady: ret = %d\n",(int)scsi_ppa_TestUnitReady(pb));
		printf("Inquiry: ret = %d\n",(int)scsi_ppa_Inquiry(pb,(InquiryData*)&data));
		printf("Read block 0 - ret = %d\n",(int)scsi_ppa_Read(pb,p,512,0,1));

		parport_releaseport(pb);
		}
		
	free(p);

	return(0);
	}
