
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef _H_PPA_LOWLEVEL
#define _H_PPA_LOWLEVEL

#include "parport.h"

/* definitions */
#define	CONNECT_NORMAL		0
#define CONNECT_EPP_MAYBE	1

#define PPA_NIBBLE			1
#define PPA_PS2				2
#define PPA_EPP_8			3
#define PPA_EPP_16			4
#define PPA_EPP_32			5
#define PPA_UNKNOWN			6

#define PPA_SECTOR_SIZE     512
#define PPA_SELECT_TMO		5000
#define PPA_SPIN_TMO		50000

#define  READ_6				0x08
#define	 READ_10			0x28
#define  WRITE_6			0x0a
#define	 WRITE_10			0x2a


#define IN_EPP_MODE(port)	(port->modes & PARPORT_MODE_PCEPP)

#define r_dtr(x)			(unsigned char)read_io_8((x))
#define r_str(x)			(unsigned char)read_io_8((x)+1)
#define r_ctr(x)			(unsigned char)read_io_8((x)+2)
#define r_epp(x)			(unsigned char)read_io_8((x)+4)
#define r_fifo(x)			(unsigned char)read_io_8((x)+0x400)
#define r_ecr(x)			(unsigned char)read_io_8((x)+0x402)

#define w_dtr(x,y)			write_io_8((x),y)
#define w_str(x,y)			write_io_8((x)+1,y)
#define w_ctr(x,y)			write_io_8((x)+2,y)
#define w_epp(x,y)			write_io_8((x)+4,y)
#define w_fifo(x,y)			write_io_8((x)+0x400,y)
#define w_ecr(x,y)			write_io_8((x)+0x402,y)

#define STATUS_FAILED		-1
#define DID_OK				0
#define DID_ABORT			1
#define	DID_RESET			2
#define	DID_TIME_OUT		3
#define	DID_BAD_TARGET		4
#define DID_NO_CONNECT		5
#define DID_ERROR			6
#define	STATUS_MASK			0x3e
#define PPA_BURST_SIZE		512

/* structures */
typedef struct
	{
	int			target;
	int			cmd_len;
	char*		cmnd;
	char*		request_buffer;
	int			request_bufflen;
	int			phase;
	int			status;
	int			result;
	} Scsi_Cmnd;



/* prototypes */
int ppa_init(struct parport* port);
int ppa_command(struct parport* port,Scsi_Cmnd* cmd);
int ppa_SendCommand(struct parport* port,void* cmd,uint cmdlen,void* data,uint datalen);




#endif

