
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#ifndef _H_SCSI
#define _H_SCSI

#include <SupportDefs.h>
#include "util.h"


#define		SCSICMD_TESTUNITREADY				0x00
#define		SCSICMD_REQUESTSENSE				0x03
#define		SCSICMD_INQUIRY						0x12
#define		SCSICMD_STARTSTOP					0x1b
#define		SCSICMD_LOCKUNLOCK					0x1e
#define		SCSICMD_READCAPACITY				0x25
#define		SCSICMD_MODESENSE					0x1a
#define		SCSICMD_READ						0x08
#define		SCSICMD_WRITE						0x0a



/*
+------------------------------------------------------------------------+
| Command result data                                                    |
|                                                                        |
+========================================================================+
*/
typedef struct
	{
    BITDEF2(uchar,        	peripheralQualifier:3,
                            peripheralDeviceType:5);
	BITDEF2(uchar,          removableMedia:1,
                           	deviceTypeModifier:7);
	BITDEF3(uchar,          isoVersion:2,
                           	ecmaVersion:3,
                          	ansiVersion:3);
	BITDEF4(uchar,          aenc:1,
                           	trmiop:1,
                           	res3:2,
                           	responseDataFormat:4);
	uchar                   additionalLength;
	uchar                   res5;
	uchar                   res6; 
	BITDEF8(uchar,          relativeAddress:1,
                           	wbus32:1,
                            wbus16:1,
                            sync:1,
                            linked:1,
                            res7:1,
                            cmdque:1,
                            sftre:1);
	char                    vendorId[8];
    char                    productId[16];
    char                    revision[4];
	char					vendorSpecific[20];
	} InquiryData;


typedef struct
	{
    BITDEF2(uchar,        	valid:1,
                            errorNumber:7);
	uchar					segmentNumber;
	BITDEF5(uchar,			filemark:1,
							eom:1,
							ili:1,
							res:1,
							senseKey:4);
	uchar					info[2];
	uchar					additionalSenseLength;
	uchar					cmdSpecific[2];
	uchar					additionalSenseCode;
	uchar 					additionalSenseQualifier;
	uchar					fieldReplacementCode;
	BITDEF2(uchar,			sksv:1,
							senseKeySpecific1:7);
	uchar					senseKeySpecific2;							
	uchar					senseKeySpecific3;							


	unsigned char			data[60];

	} SenseData;


//+------------------------------------------------------------------------+
//| command data block                                                     |
//|                                                                        |
//|                                                                        |
//+========================================================================+
typedef struct
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							res1:5);
	uchar					res2;
	uchar					res3;
	uchar					length;
	uchar					control;
	} CMD_RequestSense;

typedef struct
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							res1:5);
	uchar					res2;
	uchar					res3;
	uchar					res4;
	uchar					control;
	} CMD_TestUnitReady;
	
typedef struct
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							res1:5);
	uchar					res2;
	uchar					res3;
	uchar					datalen;
	uchar					control;
	} CMD_Inquiry;
	
typedef struct
	{
	uchar					opcode;
	BITDEF3(uchar,			lun:3,
							res1:4,
							immediate:1);
	uchar					res2;
	uchar					res3;
	BITDEF3(uchar,			res4:6,
							eject:1,
							start:1);
	uchar					control;
	} CMD_StartStop;
	
typedef struct
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							res1:5);
	uchar					res2;
	uchar					res3;
	BITDEF2(uchar,			res4:7,
							prevent:1);
	uchar					control;
	} CMD_LockUnlock;
	
typedef struct 																																															
	{
	uchar					opcode;
	BITDEF4(uchar,			lun:3,
							res1:1,
							dbd:1,
							res2:3);
	BITDEF2(uchar,			pc:2,
							pagecode:6);
	uchar					res3;
	uchar					length;
	uchar					control;
	} CMD_ModeSense;
	
typedef struct
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							lb:5);
	uchar					logicalBlock[2];
	uchar					length;
	uchar					control;																						
	} CMD_Read;
	
typedef struct 
	{
	uchar					opcode;
	BITDEF2(uchar,			lun:3,
							lb:5);
	uchar					logicalBlock[2];
	uchar					length;
	uchar					control;
	} CMD_Write;							
		

#endif

