
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include "scsi.h"
#include "ppa_lowlevel.h"

#define PPA_ZIP_LUN	6

status_t scsi_ppa_Init(struct parport* port)
	{
	return(ppa_init(port));
	}

status_t scsi_ppa_TestUnitReady(struct parport* port)
	{
	CMD_TestUnitReady cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode = SCSICMD_TESTUNITREADY;		
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}
	
status_t scsi_ppa_Inquiry(struct parport* port,InquiryData* data)
	{
	CMD_Inquiry cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode	= SCSICMD_INQUIRY;
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),data,sizeof(InquiryData)));
	}	
	
status_t scsi_ppa_Read(struct parport* port,void* buf,ulong bufsize,ulong logicalBlock,ulong count)
	{
	CMD_Read cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode			= SCSICMD_READ;
	cmd.lb				= logicalBlock >> 16;
	cmd.logicalBlock[0] = logicalBlock >> 8;
	cmd.logicalBlock[1] = logicalBlock;
	cmd.length			= count;
	
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),buf,bufsize));
	}
	
status_t scsi_ppa_Write(struct parport* port,const void* buf,ulong bufsize,ulong logicalBlock,ulong count)
	{
	CMD_Write cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode			= SCSICMD_WRITE;
	cmd.lb				= logicalBlock >> 16;
	cmd.logicalBlock[0] = logicalBlock >> 8;
	cmd.logicalBlock[1] = logicalBlock;
	cmd.length			= count;
	
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),(void*)buf,bufsize));
	}
	
status_t scsi_ppa_Lock(struct parport* port)
	{
	CMD_LockUnlock cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode		= SCSICMD_LOCKUNLOCK;
	cmd.prevent		= true;
	
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}	
		
status_t scsi_ppa_Unlock(struct parport* port)
	{
	CMD_LockUnlock cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode		= SCSICMD_LOCKUNLOCK;
	cmd.prevent		= false;
	
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}	

status_t scsi_ppa_Start(struct parport* port)
	{
	CMD_StartStop cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode		= SCSICMD_STARTSTOP;
	cmd.eject		= false;
	cmd.start		= true;
		
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}	

status_t scsi_ppa_Stop(struct parport* port)
	{
	CMD_StartStop cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode		= SCSICMD_STARTSTOP;
	cmd.eject		= false;
	cmd.start		= false;
		
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}	

status_t scsi_ppa_Eject(struct parport* port)
	{
	CMD_StartStop cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode		= SCSICMD_STARTSTOP;
	cmd.eject		= true;
	cmd.start		= false;
		
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),NULL,0));
	}	

status_t scsi_ppa_RequestSense(struct parport* port,SenseData* data)
	{
	CMD_RequestSense cmd;
	memset(&cmd,0,sizeof(cmd));
	
	cmd.opcode	= SCSICMD_REQUESTSENSE;
	cmd.lun		= PPA_ZIP_LUN;
	cmd.length	= sizeof(SenseData);
	
	return(ppa_SendCommand(port,&cmd,sizeof(cmd),data,sizeof(SenseData)));
	}	

			