
//		Copyright © 1999		Matthew S. Chartier (mattc@ic.net)
//
//		This program is free software; you can redistribute it and/or modify
//		it under the terms of the GNU General Public License as published by
//		the Free Software Foundation; either version 1, or (at your option)
//		any later version.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, write to the Free Software
//		Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _H_SCSI_PPA
#define _H_SCSI_PPA

#include "parport.h"
#include "scsi.h"


status_t 		scsi_ppa_Init(struct parport*);
status_t 		scsi_ppa_TestUnitReady(struct parport*);
status_t 		scsi_ppa_Inquiry(struct parport*,InquiryData* data);
status_t 		scsi_ppa_Read(struct parport*,void* buf,ulong bufsize,ulong logicalBlock,ulong count);
status_t 		scsi_ppa_Write(struct parport*,const void* buf,ulong bufsize,ulong logicalBlock,ulong count);
status_t 		scsi_ppa_Lock(struct parport*);
status_t 		scsi_ppa_Unlock(struct parport*);
status_t 		scsi_ppa_Start(struct parport*);
status_t 		scsi_ppa_Stop(struct parport*);
status_t 		scsi_ppa_Eject(struct parport*);
status_t 		scsi_ppa_RequestSense(struct parport* port,SenseData* data);


#endif

