/* Copyright (C) 1998, Synack Systems Corporation.  Created 1998. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "Synack Systems Corp., BeProtected IP Packet
   Filter" in all material mentioning or referencing this software.

   License is also granted to make and use derivative works provided
   that such works are identified as "derived from the Synack Systems
   Corp., BeProtected IP packet filter" in all material
   mentioning or referencing the derived work.

   Synack Systems Corp.  makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
 */       

struct FirewallFilter {

#define FILTER_DST_PORT			0x01
#define FILTER_ALLOW            0x02
#define FILTER_SRC_ADDRESS		0x04
#define FILTER_PROTOCOL			0x08
#define FILTER_FLAGS			0x10
#define FILTER_INTERFACE		0x20
#define FILTER_DST_ADDRESS		0x40
#define FILTER_IP_OPTIONS		0x80
#define FILTER_SRC_PORT			0xFF

	int flags;
	unsigned ip_src[2], ip_dst[2];
	unsigned short dport[2], sport[2];
	unsigned char protocol;
	unsigned char th_flags;
	char ppp, eth;
};     

extern BList *filters;

void addFilter(struct FirewallFilter *f);
void readFilters(char *file);
unsigned packIP(char *s);
void parsePortRange(char *s, unsigned short ports[]);
void parseIpRange(char *s, unsigned ip[]);
