/* Copyright (C) 1998, Synack Systems Corporation.  Created 1998. All
   rights reserved.

   License to copy and use this software is granted provided that it
   is identified as the "Synack Systems Corp., BeProtected IP Packet
   Filter" in all material mentioning or referencing this software.

   License is also granted to make and use derivative works provided
   that such works are identified as "derived from the Synack Systems
   Corp., BeProtected IP packet filter" in all material
   mentioning or referencing the derived work.

   Synack Systems Corp.  makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
 */       

#include <NetDevice.h>
#include <NetProtocol.h>
#include <stdio.h>
#include <memory.h>
#include "headers.h"
#include "firewall.h"
#include "filter.h"
#include "FirewallPacketHandler.h"
#include "config.h"

FILE *flog;

class FirewallProtocol : public BNetProtocol {
public:
   FirewallPacketHandler *handler;
   FirewallProtocol() {
     handler = new FirewallPacketHandler();
     readFilters(FILTERS_FILE);
   }
   void AddDevice(BNetDevice *device, const char *name) {
	  // Give ourselves a really high prority -- we are the firewall afterall
	  register_packet_handler(handler, device, 1000000);
   }
};

#pragma export on
BNetProtocol *open_protocol(const char *devname) {
  flog = fopen(LOG_FILE, "a+");
  fprintf(flog, "BeProtected started\n"); fflush(flog);
  return (new FirewallProtocol());
}
#pragma export off