#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Window.h>
#include <TextView.h>
#include "str.h"
#include "widgets.h"
#include "amc.h"

const int buf_max=200;

enum {
  eSet, eAdd_Take,        // modify script
};

struct Rewr_script {
  const int
    start,
    stop,
    meter;
  bool insert_gap;
  char in_buf[buf_max],
       out_buf[buf_max];
  Rewr_script(int sta,int sto,int m):
      start(sta),stop(sto),meter(m),insert_gap(sto>sta) { }
  int read_time(Str &str,int &pos);
  void rewr_line(bool &ok);
  void rewr_params(Str &str,int &pos,int mode,char *&ob,bool &ok);
};

void cpy_str(char *s,char *&ob) {
  char *ib;
  for (ib=s;*ib;) *(ob++)=*(ib++);
}

void cpy_char(char ch,char *&ob) {
  switch (ch) {
    case ';': cpy_str("; ",ob); break;
    case ' ': cpy_str(" ",ob); break;
    case '#': cpy_str(" #",ob); break;
    case '\n': cpy_str("\n",ob); break;
    default: ob[0]=ch; ob[1]=0; alert("unexpected char (%c)",ch);
  }
}

int Rewr_script::read_time(Str &str,int &pos) {
  str.strtok(in_buf," .,\n;",pos);
  int nr=atoi(str.s) * meter;
  if (str.ch=='.') {
    str.strtok(in_buf," \n;",pos);
    nr+=atoi(str.s);
  }
  return nr;
}

void Rewr_script::rewr_params(Str &str,int &pos,int mode,char *&ob,bool &omit) {
  int tim;
  char *lst_ob,*prev_ob;
  omit=false;
  for (;;) {
    str.strtok(in_buf," :;\n#",pos);
    if (str.ch==':') {
      if (str=="time") {
        cpy_str("time:",ob);
        lst_ob=prev_ob=ob;
        for(;;) {
          tim=read_time(str,pos);
          if (insert_gap) {
            if (tim>=start) tim+=stop-start+1;
          }
          else {
            if (debug) printf("tim=%d start=%d stop=%d\n",tim,start,stop);
            switch (mode) {
              case eAdd_Take:
                if (tim>=start) tim+=stop-start+1;
                else if (tim>=stop) {
                  ob=lst_ob;
                  goto find_comma;
                }
                break;
              case eSet:
                if (tim>start) tim+=stop-start+1;
                else if (tim>=stop) tim=stop;
                break;
            }
          }
          if (tim % meter > 0)
            ob += sprintf(ob,"%d.%d",tim/meter,tim%meter);
          else
            ob += sprintf(ob,"%d",tim/meter);
          find_comma:
          if (str.ch!=',') break;
          if (lst_ob!=ob) {
            lst_ob=ob;
            cpy_str(",",ob);
          }
        }
        if (mode==eAdd_Take && ob==prev_ob) omit=true;
      }
      else {
        cpy_str(str.s,ob);
        cpy_str(":",ob);
        str.strtok(in_buf," ;\n#",pos);
        cpy_str(str.s,ob);
      }
    }
    else
      cpy_str(str.s,ob);
    if (str.ch=='\n' || str.ch=='#') break;
    cpy_char(str.ch,ob);
  }
}

void Rewr_script::rewr_line(bool &ok) {
  int pos=0,
      mode=0;
  char *ob=out_buf,
       *prev_ob;
  bool omit;
  Str str;
  for (;;) {
    prev_ob=ob;
    str.strtok(in_buf," :;\n#",pos);
    if (!str.s[0]);
    else if (str=="put") {
      cpy_str("put ",ob);
      str.strtok(in_buf," ;\n#",pos);
      cpy_str(str.s,ob);
    }
    else if (str=="exit") {
      cpy_str("exit",ob);
    }
    else if (str=="set") {
      cpy_str("set ",ob);
      rewr_params(str,pos,eSet,ob,omit);
    }
    else if (str=="add" ||
             str=="take" ||
             str=="take-nc") {
      cpy_str(str.s,ob);
      cpy_str(" ",ob);
      rewr_params(str,pos,eAdd_Take,ob,omit);
      if (omit) ob=prev_ob;
    }
    else {
      alert("modify script: unknown cmd \"%s\"",str.s);
      ok=false;
      return;
    }

    cpy_char(str.ch,ob);
    if (str.ch=='\n') break;
    if (str.ch=='#') {
      cpy_str(in_buf+pos,ob);
      break;
    }
  }
  *ob=0;
}

void AppWindow::modify_script(const char *scriptf,int start,int stop,int meter) {
  // supposed: ok = false
  char in_line[buf_max],
       out_line[buf_max];
  FILE *in,
       *out;
  Str old_scriptf(scriptf),
      str;
  if (start==stop) {
    alert("modify script: start=%d, stop=%d",start,stop);
    return;
  }
  old_scriptf.new_ext(".scr-old");
  if (rename(scriptf,old_scriptf.s)) {
    alert("renaming \"%s\" to \"%s\" failed",scriptf,old_scriptf.s); return;
  }
  if (!(in=fopen(old_scriptf.s,"r"))) {
    alert("\"%s\" unknown",old_scriptf.s); return;
  }
  if (!(out=fopen(scriptf,"w"))) {
    alert("%s not opened",scriptf); return;
  }
  bool ok=true;
  Rewr_script rwscr(start,stop,meter);
  for (;;) {
    char *s=fgets(rwscr.in_buf,buf_max,in);
    if (!s) break;
    rwscr.rewr_line(ok);
    if (!ok) break;
    if (debug) printf("inl:[%s] outl:[%s]\n",rwscr.in_buf,rwscr.out_buf);
    fputs(rwscr.out_buf,out);
  }
  fclose(in);
  fclose(out);
  if (ok) alert("new script %s written",scriptf);
}
