#include <stdio.h>
#include <Application.h>
#include <File.h>
#include <Roster.h>
#include <AppFileInfo.h>
#include <Bitmap.h>

int error_found;

const char *tunes_mime="audio/AMC-tunes",
           *script_mime="text/AMC-script",
           *app_mime="application/AMC-app";

struct Bitmaps {
  BBitmap *ALI_bm, *ASI_bm, // app
          *TLI_bm, *TSI_bm, // tunes
          *SLI_bm, *SSI_bm; // script
  Bitmaps();
};

Bitmaps::Bitmaps() {
  const uint8 _ = B_TRANSPARENT_MAGIC_CMAP8,
              b = 0,  // black
              r = 0x2a, // red
              u = 0x20;  // blue
  static uint8
    sharp[] = {
      _,_,_,_,_,_,_,_,
      _,_,_,b,_,b,_,_,
      _,b,b,b,b,b,_,_,
      _,_,b,_,b,_,_,_,
      _,_,b,_,b,_,_,_,
      _,b,b,b,b,b,_,_,
      _,b,_,b,_,_,_,_,
      _,_,_,_,_,_,_,_
    },
    flat[] = {
      _,_,_,_,_,_,_,_,
      _,_,b,_,_,_,_,_,
      _,_,b,_,_,_,_,_,
      _,_,b,b,b,_,_,_,
      _,_,b,_,_,b,_,_,
      _,_,b,_,b,_,_,_,
      _,_,b,b,_,_,_,_,
      _,_,_,_,_,_,_,_
    },
    dum[] = {
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b
    },
    app_large[] = {
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,r,r,r,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,r,r,_,_,_,_,_,_,_,_,
	_,_,u,_,_,_,u,u,_,u,u,_,_,u,u,_,_,_,r,r,_,_,r,r,r,_,_,_,_,_,_,_,
	_,u,_,u,_,_,u,_,u,_,u,_,u,_,_,u,_,_,r,r,_,_,_,r,r,_,_,_,_,_,_,_,
	u,_,_,_,u,_,u,_,u,_,u,_,u,_,_,u,_,_,r,r,_,_,_,r,r,r,_,_,_,_,_,_,
	u,_,_,_,u,_,u,_,_,_,u,_,u,_,_,_,_,_,r,r,_,_,_,_,r,r,_,_,_,_,_,_,
	u,_,_,_,u,_,u,_,_,_,u,_,u,_,_,_,_,_,r,r,_,_,_,_,r,r,r,_,_,_,_,_,
	u,u,u,u,u,_,u,_,_,_,u,_,u,_,_,u,_,_,r,r,_,_,_,_,_,r,r,_,_,_,_,_,
	u,_,_,_,u,_,u,_,_,_,u,_,u,_,_,u,_,_,r,r,_,_,_,_,_,r,r,r,_,_,_,_,
	u,_,_,_,u,_,u,_,_,_,u,_,_,u,u,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,r,r,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,r,r,_,_,_,_,_,
	_,_,_,_,_,_,_,_,r,r,r,r,r,r,_,_,_,_,r,r,_,_,_,_,_,r,_,_,_,_,_,_,
	_,_,_,_,_,_,r,r,r,r,r,r,r,r,r,r,_,_,r,r,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,r,_,r,r,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,r,r,r,r,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,r,r,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_
   },
   app_small[] = {
	_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,r,_,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,r,r,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,r,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,r,_,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,_,r,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,_,r,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,_,r,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,_,r,_,_,
	_,_,_,_,_,_,_,_,_,r,_,_,r,_,_,_,
	_,_,_,r,r,r,r,r,_,r,_,_,r,_,_,_,
	_,_,r,r,r,r,r,r,r,r,_,_,_,_,_,_,
	_,_,r,r,r,r,r,r,r,r,_,_,_,_,_,_,
	_,_,r,r,r,r,r,r,r,r,_,_,_,_,_,_,
	_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_
    },
    tunes_large[] = {
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,r,r,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,r,b,b,b,b,b,b,b,b,b,r,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,r,b,b,b,b,b,b,b,b,b,r,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,r,_,_,_,_,_,_,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,r,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,r,r,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,r,r,r,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_
    },
    tunes_small[] = {
	_,_,_,_,_,_,_,_,_,r,r,_,_,_,_,_,
	_,_,_,_,_,_,_,r,r,r,r,_,_,_,_,_,
	_,_,_,_,_,r,r,r,_,_,r,_,_,_,_,_,
	b,b,b,b,b,r,r,b,b,b,r,b,b,b,b,b,
	_,_,_,_,_,r,_,_,_,_,r,_,_,_,_,_,
	_,_,_,_,_,r,_,_,_,_,r,_,_,_,_,_,
	b,b,b,b,b,r,b,b,b,b,r,b,b,b,b,b,
	_,_,_,_,_,r,_,_,r,r,r,_,_,_,_,_,
	_,_,_,_,_,r,_,_,r,r,r,_,_,_,_,_,
	b,b,b,b,b,r,b,b,b,b,b,b,b,b,b,b,
	_,_,_,r,r,r,_,_,_,_,_,_,_,_,_,_,
	_,_,_,r,r,r,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
    },
    script_large[] = {
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,u,u,u,u,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,u,u,u,u,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,u,u,u,u,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,u,u,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,u,b,b,b,b,b,b,b,b,b,u,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,u,b,b,b,b,b,b,b,b,b,u,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,u,_,_,_,_,_,_,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,u,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,u,u,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,u,u,u,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_
    },
    script_small[] = {
	_,_,_,_,_,_,_,_,_,u,u,_,_,_,_,_,
	_,_,_,_,_,_,_,u,u,u,u,_,_,_,_,_,
	_,_,_,_,_,u,u,u,_,_,u,_,_,_,_,_,
	b,b,b,b,b,u,u,b,b,b,u,b,b,b,b,b,
	_,_,_,_,_,u,_,_,_,_,u,_,_,_,_,_,
	_,_,_,_,_,u,_,_,_,_,u,_,_,_,_,_,
	b,b,b,b,b,u,b,b,b,b,u,b,b,b,b,b,
	_,_,_,_,_,u,_,_,u,u,u,_,_,_,_,_,
	_,_,_,_,_,u,_,_,u,u,u,_,_,_,_,_,
	b,b,b,b,b,u,b,b,b,b,b,b,b,b,b,b,
	_,_,_,u,u,u,_,_,_,_,_,_,_,_,_,_,
	_,_,_,u,u,u,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
	b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
  };

  (ALI_bm  = new BBitmap(BRect(0,0,31,31),B_CMAP8))->SetBits(app_large,32*32,0,B_CMAP8);
  (ASI_bm  = new BBitmap(BRect(0,0,15,15),B_CMAP8))->SetBits(app_small,16*16,0,B_CMAP8);
  (TLI_bm  = new BBitmap(BRect(0,0,31,31),B_CMAP8))->SetBits(tunes_large,32*32,0,B_CMAP8);
  (TSI_bm  = new BBitmap(BRect(0,0,15,15),B_CMAP8))->SetBits(tunes_small,16*16,0,B_CMAP8);
  (SLI_bm  = new BBitmap(BRect(0,0,31,31),B_CMAP8))->SetBits(script_large,32*32,0,B_CMAP8);
  (SSI_bm  = new BBitmap(BRect(0,0,15,15),B_CMAP8))->SetBits(script_small,16*16,0,B_CMAP8);
}

enum {
  eFlat=1, eSharp
};
 
void err(char *s) {
  printf("set_attr: %s\n",s);
  error_found=1;
}

void install_mimetype(const char *mime_str,const char *app_type,BBitmap *large,BBitmap *mini) {
  BMimeType mime(mime_str);
  if (mime.IsInstalled()) {
    char s[100];
    mime.GetPreferredApp(s);
    if (strcmp(s,app_type)) { mime.Delete(); printf("MIME %s deleted\n",mime_str); }
    else return;
  }
  if (mime.SetIcon(mini,B_MINI_ICON)!=B_OK ||
      mime.SetIcon(large,B_LARGE_ICON)!=B_OK) {
    err("mime: icon?");
    return;
  }
  mime.SetPreferredApp(app_type);
  BMessage msg;
  if (mime.Install()==B_OK)
    printf("MIME type %s installed\n",mime_str);
  else
    err("installing MIME type failed");
}

struct App: public BApplication {
  App(): BApplication("application/set_amc_attr") {
    BFile theFile("amc", B_READ_WRITE);
    if (theFile.InitCheck()!=B_OK) {
      err("app file?"); return;
    }
    BAppFileInfo appInfo(&theFile);
    if (appInfo.InitCheck()!=B_OK) {
      err("appInfo?"); return;
    }
    // appInfo.SetInfoLocation(B_ATTRIBUTES); // use attributes
    if (appInfo.SetAppFlags(B_MULTIPLE_LAUNCH)!=B_OK) {
      err("app flags?"); return;
    }
    if (appInfo.SetSignature(app_mime)!=B_OK) { // <-- without: no SetSupportedTypes
      err("signature?"); return;
    }
    BMimeType mime(app_mime);
    if (!mime.IsInstalled()) {
      if (mime.Install()!=B_OK) {   // <-- without: no SetSupportedTypes
        err("app MIME type install?"); return;
      }
      else printf("MIME type %s installed\n",app_mime);
    }
    BMessage types;
    types.AddString("types",script_mime);
    types.AddString("types",tunes_mime);
    if (appInfo.SetSupportedTypes(&types)!=B_OK) {
      err("supported types?"); return;
    } 
    Bitmaps bitmaps;
    if (appInfo.SetIcon(bitmaps.ALI_bm,B_LARGE_ICON)!=B_OK ||
        appInfo.SetIcon(bitmaps.ASI_bm,B_MINI_ICON)!=B_OK) {
      err("icon?");
      return;
    }
    theFile.Unset();

    install_mimetype(tunes_mime,app_mime,bitmaps.TLI_bm,bitmaps.TSI_bm);
    install_mimetype(script_mime,app_mime,bitmaps.SLI_bm,bitmaps.SSI_bm);
  }
};

int main(int argc, char** argv) {
  if (argc<2 || strcmp(argv[1],"amc")) { err("arg should be \"amc\""); exit(1); }
  App app;
  exit(error_found);
}
