struct Sampler {
  BSoundPlayer *player;
  Sampler();
  void playScore(int start,int stop);
};

struct RedCtrl: StdView {
  RedCtrl(BRect);
  HVSlider *start_timbre,
           *timbre;
  HSlider *startup,
          *decay;
  CheckBox *soft_attack;
  void set_startup();
  void set_attack();
  void set_decay();
  void set_start_timbre();
  void set_timbre();
  void redraw_sliders();
  void Draw(BRect);
};

struct BlackCtrl: StdView {
  BlackCtrl(BRect,BlackCtrl*&);
  HVSlider *fm_ctrl;
  HSlider *detune,*attack,*decay;
  double act_freq,display_mod; // set by set_fm()
  CheckBox *sub_band;
  void set_fm(int);
  void set_detune();
  void set_attack();
  void set_decay();
  void redraw_sliders();
};

struct BrownCtrl: StdView {
  BrownCtrl(BRect,BrownCtrl*&);
  HVSlider *fm_ctrl;
  HSlider *detune,*attack,*decay;
  double act_freq,display_mod; // set by set_fm()
  CheckBox *sub_band;
  void set_fm(int);
  void set_detune();
  void set_attack();
  void set_decay();
  void redraw_sliders();
};

struct GreenCtrl: StdView {
  GreenCtrl(BRect);
  HSlider *attack, *decay;
  VSlider *tone;
  void set_attack(), set_decay();
  void redraw_sliders();
};

struct PurpleCtrl: StdView {
  PurpleCtrl(BRect,PurpleCtrl*&);
  VSlider *harm[harm_max];    // harmonics
  VSlider *st_harm[harm_max]; // startup harmonics
  HSlider *start_dur;           // attack duration
  void set_hs_ampl(int*);
  void set_st_hs_ampl(int*);
  void set_start_dur();
  void Draw(BRect);
  void redraw_sliders();
};

struct BlueCtrl: StdView {
  BlueCtrl(BRect);
  HSlider *attack,*decay;
  CheckBox *chorus,*rich,*p_attack;
  void set_attack();
  void set_decay();
  void set_piano();
  void redraw_sliders();
};

struct ShowSampled: StdView {
  ShowSampled(BRect);
  void Draw(BRect);
};

bool exec_info(int,Score*);
void connect_stereo(Rot **);
int col2wav_nr(int note_col);
