#include "Being.h"
#include "Cell.h"

cBeing::cBeing( cCell *c )
{
	thePicture = NULL;
	theCell = c;

	age = 0;
	max_age = 5;

	made_move = true;

	health = 100;
}

// Returns the type of the being.
uint32 cBeing::GetType( void )
{
	return type;
}

// Simply returns a pointer for the Cell's Draw() function
BBitmap* cBeing::GetPicture( void )
{
	return thePicture;
}

// Reset the being for the next move
void cBeing::Update( void )
{
	made_move = false;
}

// Tell the Being what it's parent cell is
void cBeing::SetCell( cCell *c )
{
	theCell = c;
}

// Return the health of the being
// Between 0 and 100  (100 = full health)
int cBeing::GetHealth( void )
{
	return health;
}

// Return the cell to move to.
// Return NULL if this being's time in the world has ended.
cCell* cBeing::MakeMove( int gen )
{
	return NULL;
}