#ifndef _WORLD_H_
#define _WORLD_H_

#include <View.h>

#include "Being.h"
#include "Cell.h"
#include "Fish.h"
#include "Pollution.h"
#include "Shark.h"

class cWorld
{
	public:
		// Constructor takes a BView to make the cells children of.
		cWorld( BView* );
		// Cycles through all cells to get life rolling
		void Run( void );
		// Returns a random neighbor of c (that has not already been returned).  Or NULL when done.
		cCell* GetNextNeighbor( cCell *c );
		// Returns the cell c's index in theCells array
		int GetCellIndex( cCell *c );
		// Forces a redraw of the whole world.
		void Redraw( void );
		// Returns the current generation count.
		uint GetGeneration( void );
		// Holds on to the BView that the World is in.  (so that the cells can use it)
		BView *theView;

	private:
		// Array of pointers that holds all the cells
		cCell **theCells;
		// Array of pointers to all the neighbors of all cells.  Used simply to track which cells have or have not been returned by GetNextNeighbor()
		bool **neighbor_check;
		// Array of cells that tracks if the cell has been run through yet.
		bool *cell_check;
		// Resets neighbor_check after each generation
		void ResetNeighbors( );
		// Resets cell_check after each generation
		void ResetCells( );
		// Keeps the size of the world.
		int width, height;
		// Track the current generation
		uint generation;
};

#endif