//  (C) Copyright Steve Cleary, Beman Dawes, Howard Hinnant & John Maddock 2000.
//  Permission to copy, use, modify, sell and
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

//  See http://www.boost.org for most recent version including documentation.

#ifndef BOOST_DETAIL_CALL_TRAITS_HPP
#define BOOST_DETAIL_CALL_TRAITS_HPP

#ifndef BOOST_CONFIG_HPP
#include <boost/config.hpp>
#endif

#ifndef BOOST_TYPE_TRAITS_HPP
#include <boost/type_traits.hpp>
#endif

namespace boost{

namespace detail{

template <typename T, bool isp, bool b1, bool b2>
struct ct_imp
{
   typedef const T& param_type;
};

template <typename T, bool isp>
struct ct_imp<T, isp, true, true>
{
   typedef T const param_type;
};

template <typename T, bool b1, bool b2>
struct ct_imp<T, true, b1, b2>
{
   typedef T const param_type;
};

}

template <typename T>
struct call_traits
{
public:
   typedef T value_type;
   typedef T& reference;
   typedef const T& const_reference;
   //
   // C++ Builder workaround: we should be able to define a compile time
   // constant and pass that as a single template parameter to ct_imp<T,bool>,
   // however compiler bugs prevent this - instead pass three bool's to
   // ct_imp<T,bool,bool,bool> and add an extra partial specialisation
   // of ct_imp to handle the logic. (JM)
   typedef typename detail::ct_imp<T, ::boost::is_pointer<typename remove_const<T>::type>::value, ::boost::is_arithmetic<typename remove_const<T>::type>::value, sizeof(T) <= sizeof(void*)>::param_type param_type;
};

template <typename T>
struct call_traits<T&>
{
   typedef T& value_type;
   typedef T& reference;
   typedef const T& const_reference;
   typedef T& param_type;  // hh removed const
};
#if 0
template <typename T, std::size_t N>
struct call_traits<T [N]>
{
   typedef T* const value_type;            // hh was typedef T value_type[N];
   typedef T (&reference)[N];             // hh was typedef T*& reference;
   typedef const T (&const_reference)[N]; // hh was typedef const T*& const_reference;
   typedef value_type param_type;        // hh was typedef T* param_type;
};
#elif 0
template <typename T, std::size_t N>
struct call_traits<T [N]>
{
private:
   typedef T array_type[N];
public:
   typedef array_type& value_type;
   typedef value_type reference;
   typedef const array_type& const_reference;
   typedef value_type param_type;
};
#else
template <typename T, std::size_t N>
struct call_traits<T [N]>
{
   typedef T*const value_type;
   typedef T*const reference;
   typedef const T*const const_reference;
   typedef value_type param_type;
};
#endif

}

#endif // BOOST_DETAIL_CALL_TRAITS_HPP
