/*
Open Tracker License

Terms and Conditions

Copyright (c) 1991-2000, Be Incorporated. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice applies to all licensees
and shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF TITLE, MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
BE INCORPORATED BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of Be Incorporated shall not be
used in advertising or otherwise to promote the sale, use or other dealings in
this Software without prior written authorization from Be Incorporated.

Tracker(TM), Be(R), BeOS(R), and BeIA(TM) are trademarks or registered trademarks
of Be Incorporated in the United States and other countries. Other brand product
names are registered trademarks or trademarks of their respective holders.
All rights reserved.
*/

#ifndef __STATUS_VIEW__
#define __STATUS_VIEW__

#include <Control.h>
#include <Node.h>
#include <Query.h>
#include <Shelf.h>
#include <View.h>

#include "BarView.h"
#include "TimeView.h"

const float kMaxReplicantHeight = 16.0f;
const float kMaxReplicantWidth = 16.0f;
const int32 kMinimumReplicantCount = 6;
const int32	kIconGap = 2;
const int32 kGutter = 1;
const int32 kDragRegionWidth = 6;

//	1 pixel left gutter
//	space for replicant tray (6 items)
//	6 pixel drag region
const float kMinimumTrayWidth = kIconGap
		+ (kMinimumReplicantCount * kIconGap)
		+ (kMinimumReplicantCount * kMaxReplicantWidth) + kGutter;
const float kMinimumTrayHeight = kGutter + kMaxReplicantHeight + kGutter;

const float kMinimumWindowWidth = kGutter + kMinimumTrayWidth + kDragRegionWidth;

#ifdef DB_ADDONS
struct DeskbarItemInfo {
	bool isaddon;		// attribute tagged item
	int32 id;			// id given to replicant
	dev_t edevice;		// entry_ref to item tagged
	ino_t edirectory;
	char *ename;
	node_ref nref;		// node_ref to boot vol item
	dev_t realDevice;	// device for actual item for vol unmounting
};
#endif

class TReplicantTray : public BView {
public:
	TReplicantTray(TBarView *bv, bool vertical);
	virtual ~TReplicantTray();
	
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void Draw(BRect );
	virtual void MouseDown(BPoint );
	virtual void MessageReceived(BMessage *);
	virtual void GetPreferredSize(float *, float *);
	
	void AdjustPlacement();
	
	void ShowReplicantMenu(BPoint);
	
	void SetMultiRow(bool state);
	bool IsMultiRow() const
		{ return fMultiRowMode; };
	
	status_t ItemInfo(int32 target, const char **name);
	status_t ItemInfo(const char *name, int32 *id);
	status_t ItemInfo(int32 index, const char **name, int32 *id);
	
	bool IconExists(int32 target, bool byIndex = false);		
	bool IconExists(const char *name);
	
	int32  IconCount() const;
	
	status_t AddIcon(BMessage *, int32 *id, const entry_ref * = NULL);
	
	void RemoveIcon(int32 target, bool byIndex = false);
	void RemoveIcon(const char *name);
	
	BRect IconFrame(int32 target, bool byIndex=false);
	BRect IconFrame(const char *name);
	
	bool AcceptAddon(BRect frame, BMessage *message);
	void RealignReplicants(int32 startIndex = -1);
	
	void RememberClockSettings();
	void DealWithClock(bool);

#ifdef DB_ADDONS
	status_t LoadAddOn(BEntry *entry, int32 *id);
#endif
	
private:
	BView *ViewAt(int32 *index, int32 *id, int32 target, bool byIndex=false);
	BView *ViewAt(int32 *index, int32 *id, const char *name);
	
	void RealReplicantAdjustment(int32 startindex);
	
	
	
#ifdef DB_ADDONS
	void InitAddOnSupport();
	void DeleteAddOnSupport();
	void RunAddOnQuery(BQuery *query, BVolume *volume,
	const char *predicated, bool makelive=false);
	
	bool IsAddOn(entry_ref *eref);
	bool NodeExists(node_ref*);
	
	void HandleEntryUpdate(BMessage *);
	status_t AddItem(int32 id, node_ref nref, BEntry *entry, bool isAddon);		
	
	void UnloadAddOn(node_ref *, dev_t *, bool which, bool removeAll);
	void RemoveItem(int32 id);
	
	void MoveItem(entry_ref *, ino_t toDirectory, ino_t node);
#endif		

	BPoint LocForReplicant(int32 replicantCount, int32 index, float width);
	BShelf *Shelf() const;
	
	friend class TReplicantShelf;

	TTimeView *fClock;
	TBarView *fBarView;
	TReplicantShelf *fShelf;
	
	bool fMultiRowMode;
	
	bool fAlignmentSupport;		
#ifdef DB_ADDONS
	BList *fItemList;
#endif

};

enum {
	kNoDragRegion,
	kDontDrawDragRegion,
	kAutoPlaceDragRegion,
	kDragRegionLeft,
	kDragRegionRight,
	kDragRegionTop,
	kDragRegionBottom
};

class TDragRegion : public BControl {
public:
	TDragRegion(TBarView *, BView *);
	
	virtual void AttachedToWindow();
	virtual void GetPreferredSize(float *, float *);
	virtual void Draw(BRect);
	virtual void FrameMoved(BPoint);
	virtual void MouseDown(BPoint );
	virtual void MouseUp(BPoint );
	virtual void MouseMoved(BPoint , uint32 , const BMessage *);

	void DrawDragRegion();
	BRect DragRegion() const;
	
	bool SwitchModeForRect(BPoint mouse, BRect rect, 
		bool newVertical, bool newLeft, bool newTop, int32 newState);
	
	int32 DragRegionLocation() const;
	void SetDragRegionLocation(int32);

private:
	TBarView *fBarView;
	BView *fChild;
	BPoint fPreviousPosition;
	int32 fDragLocation;
};

#endif

