#if !defined(_FSDIALOGWINDOW_H)
#define _FSDIALOGWINDOW_H

#include <Window.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Button.h>
#include <ListView.h>
#include <TextControl.h>
#include <CheckBox.h>

#include "TFSContext.h"

namespace BPrivate {

class FSDialogWindow;
class TFSContext;

class FSDialogWindow : public BWindow {
	typedef BWindow		inherited;

public:
	enum {
		kContinue = 124653562,
		kCancel,
		kRetry,
		kGo,
		kPack,
		kDefaultAnswerCB,
		kReplySelected,
		kReplyInvoked,
		kDontAskKey,
		kTextControl
	};

	enum type {
		kError,
		kInteraction
	};

	class DialogView : public BView {
	public:
		DialogView() : BView(BRect(), "SomeDialogView", B_FOLLOW_NONE, 0) { }
		
//		virtual	void	Pack()	{ }
		virtual	void	SwitchDontAsk()	{}
	};

	void	SetContinueEnabled(bool b)		{ mMainView.SetContinueEnabled(b); }

private:

	class CustomItem : public BListItem {
		typedef BListItem inherited;
		public:
			CustomItem(TFSContext::command cmd) : inherited(), mCommand(cmd) { }
			
			void	DrawItem(BView *, BRect, bool complete = false);

			bool	NeedsTextControl() const {
						return (mCommand == TFSContext::kSuppliedNewNameForSource  ||
								mCommand == TFSContext::kSuppliedNewNameForTarget) ?
							
							true : false;
					}

			TFSContext::command		Command()				{ return mCommand; }
		private:
			TFSContext::command		mCommand;
	};

	class SeparatorItem : public BListItem {
		typedef BListItem inherited;
		public:
			SeparatorItem() : inherited()					{ SetEnabled(false); }
			
			void	DrawItem(BView *, BRect, bool complete = false);
			void	Update(BView *, const BFont *)			{ SetHeight(4); }
	};

	class TFSContextDialogView : public DialogView {
		typedef DialogView	inherited;
	
		void	initialize();

		friend class CustomListView : public BListView {
				typedef BListView inherited;
			
			public:
				CustomListView() : inherited(BRect(), "AnswerList", B_SINGLE_SELECTION_LIST,
													B_FOLLOW_ALL), mPreviousSelection(-1) {}
				void	SelectionChanged();
				void	ResizeToPreferred();
//				void	TargetedByScrollView(BScrollView *);
				
			private:
				int32	mPreviousSelection;
		};

		class CustomScrollView : public BScrollView {
				friend class TFSContextDialogView;
				typedef BScrollView inherited;		

			public:
				CustomScrollView(CustomListView &view) : inherited("ScrollView", &view, B_FOLLOW_NONE,
															B_NAVIGABLE_JUMP, false, false),
														mListView(view) {}
				void	ResizeToPreferred();				

			private:
				CustomListView	&mListView;
		};
		
		class CustomDefAnswCheckBox : public BCheckBox {
			typedef BCheckBox inherited;
			public:
				CustomDefAnswCheckBox() : inherited(BRect(), "DefaultAnswerCB", "Don't ask again for this session",
													new BMessage(kDefaultAnswerCB), B_FOLLOW_NONE) {}
		};

		class CustomTextControl : public BTextControl {
			typedef BTextControl inherited;
			public:
				CustomTextControl() : inherited(BRect(), "TextControl", 0, 0, 0) {
					SetModificationMessage(new BMessage(kTextControl));
				}
		};

		class CustomTextView : public BTextView {
			typedef BTextView inherited;		

			public:
				CustomTextView() : inherited(BRect(), "TextView", BRect(), B_FOLLOW_LEFT_RIGHT, B_FRAME_EVENTS | B_WILL_DRAW) {}

				bool	CanEndLine(int32 pos) {
							if (ByteAt(pos) == '\\')
								return true;
							
							return inherited::CanEndLine(pos);
						}
				void	ResizeToPreferred();
		};

	public:
		TFSContextDialogView(TFSContext &, TFSContext::interaction);
		TFSContextDialogView(TFSContext &, status_t);
		~TFSContextDialogView();

		void	ResizeToPreferred();
//		void	Draw(BRect);
//		void	Pack();
		void	AllAttached();
		void	SetInfoText();
		void	SetTextControlText(char *text)	{ mTextControl.SetText(text); }
		void	SwitchDontAsk()	{
					mDefaultAnswerCB.SetValue(mDefaultAnswerCB.Value() == B_CONTROL_ON ? B_CONTROL_OFF : B_CONTROL_ON);
					mDefaultAnswerCB.Invoke();
				}

	private:
		TFSContext &			mContext;
		type					mType;
		TFSContext::interaction mInteractionCode;
		status_t				mErrorCode;
		CustomListView			mListView;
		CustomScrollView		mScrollView;
		CustomDefAnswCheckBox	mDefaultAnswerCB;
		CustomTextView			mTextView;
		CustomTextControl		mTextControl;
	};

	class MainView : public BView {
		typedef BView	inherited;
		friend class FSDialogWindow;
	
	public:
		MainView();
		~MainView();
		

		void	ResizeToPreferred();
		void	SetDialogView(DialogView *view);
		void	AllAttached();
		void	Draw(BRect iRect);
		void	SetTextControlText(char *text) {
					ASSERT(mDialogView != 0);

					TFSContextDialogView *v = dynamic_cast<TFSContextDialogView *>(mDialogView);
					v -> SetTextControlText(text);
				}
		void	SetContinueEnabled(bool b)	{ mContinueButton.SetEnabled(b); }
		void	SwitchDontAsk()			{ ASSERT(mDialogView != 0); mDialogView -> SwitchDontAsk(); }
		void	SetRetryButtonEnabled(bool state) {
					if (state == false)
						mRetryButton.Hide();
				}

	private:
		BButton			mContinueButton,
						mCancelButton,
						mRetryButton;
		DialogView *	mDialogView;
	};

	void	initialize();

public:
	friend class TFSContextDialogView::CustomListView;
	
	FSDialogWindow(TFSContext::command *, bool *, FSDialogWindow **, char *, char *, TFSContext &, TFSContext::interaction);
	FSDialogWindow(TFSContext::command *, bool *, FSDialogWindow **, TFSContext &, status_t);
	~FSDialogWindow();

			void			Go();
			bool			HasReply()				{ return mReply != TFSContext::kInvalidCommand; }
	TFSContext::command		Reply()					{ ASSERT(HasReply()); return mReply; }

			void			SetDialogView(DialogView *view)	{ mMainView.SetDialogView(view); }
			void			SetContext(TFSContext &context, TFSContext::interaction);
			void			SetContext(TFSContext &context, status_t);
			void			SetTextControlText(char *text)	{ mMainView.SetTextControlText(text); }
			TFSContext &	Context()						{ return mContext; }

			void			MessageReceived(BMessage *);
//			void			DispatchMessage(BMessage *, BHandler *);
			void			Pack();
			void			ResizeToPreferred();
			void			SetType(type);
			void			Cancel();
			void			Quit();

				
			bool			QuitRequested();

private:

	FSDialogWindow **		mContainer;
	char *					mSourceNewName;
	char *					mTargetNewName;
	const char *			mTextControlText;
	TFSContext::command *	mReplyPtr;
	bool *					mDefaultAnswerPtr;
	TFSContext::command		mReply;
	TFSContext &			mContext;
	MainView				mMainView;
	type					mType;
};


}	// namespace BPrivate

#endif // _FSDIALOGWINDOW_H

