#if !defined(_TRACKERFSCONTEXT_H)
#define _TRACKERFSCONTEXT_H

#include <StopWatch.h>
#include <MessageRunner.h>

#define private public			// XXX HUGE hack...
#include <StatusBar.h>
#undef private

#include <vector>

#include <boost/call_traits.hpp>

#include "FSContext.h"
#include "PoseList.h"

#define B_DESKTOP_DIR_NAME "Desktop"

namespace BPrivate {

class FSDialogWindow;

template <typename NEW_TYPE, typename OLD_TYPE>		// XXX partial specialisations with boost
inline NEW_TYPE assert_cast(OLD_TYPE in_thing) {
	ASSERT(dynamic_cast<NEW_TYPE>(in_thing) != 0);
	return static_cast<NEW_TYPE>(in_thing);
}

class TFSContext : public fs::FSContext {
	typedef	FSContext			inherited;
	typedef vector<BPoint>		point_list_t;

	struct PauseStopWatch {
		BStopWatch &	mStopWatch;
		
		PauseStopWatch(BStopWatch &in_watch) : mStopWatch(in_watch)		{ mStopWatch.Suspend(); }
		~PauseStopWatch()	{ mStopWatch.Resume(); }
	};
	
	struct PauseStopWatch_ResumeIf {
		typedef bool (TFSContext::*function_type)() const;
		
		BStopWatch &	mStopWatch;
		TFSContext *	mObject;
		function_type	mFunction;
		
		PauseStopWatch_ResumeIf(BStopWatch &in_watch, TFSContext *obj, function_type func) :
							mStopWatch(in_watch), mObject(obj), mFunction(func) {

			mStopWatch.Suspend();
		}
		~PauseStopWatch_ResumeIf() {
			if ((mObject ->* mFunction)())
				mStopWatch.Resume();
		}
	};

	void	initialize();
	
public:
	TFSContext();
	TFSContext(const PoseList &);
	TFSContext(const BMessage &);
	TFSContext(const entry_ref &);
	~TFSContext();
	
	fs::EntryIterator *	NewIterator()									{ return mEntryList.NewIterator(); }
	point_list_t &		PointList()										{ mPointList.reserve(mEntryList.size()); return mPointList; }
	fs::EntryList &		EntryList()										{ return mEntryList; }

			int32		EncapsulatedEntryCount()						{ return mEntryList.size(); }

			status_t	CalculateItemsAndSize(ProgressInfo &ininfo);
			status_t	CopyTo(BDirectory &target_dir, bool async);
			status_t	Duplicate(bool async);
			status_t	CreateLinkTo(BDirectory &target_dir, bool relative, bool async);
			status_t	MoveTo(BDirectory &target_dir, bool async);
			status_t	MoveToTrash(bool async);
			status_t	RestoreFromTrash(bool async);
			status_t	Remove(bool in_ask_user, bool async);

			void		SetInteractive(bool in_state)					{ mInteractive = in_state; }
			bool		IsInteractive() const							{ return mInteractive; }

			void		DisableProgressInfo()							{ mProgressInfoEnabled = false; }

			bool		Pause();
			bool		IsPaused() const								{ return mPause; }
			bool		IsAutoPaused() const							{ return mAutoPaused; }
			void		ContinueAutoPaused() 							{ mShouldAutoPause = false; HardResume(); }
			
			void		SoftResume();
			void		HardResume()									{ mPause = false; SoftResume(); }
			int32		EstimatedTimeLeft();
			bigtime_t	ElapsedTime() const								{ return mElapsedStopWatch.ElapsedTime(); }
			bigtime_t	RealElapsedTime() const							{ return system_time() - mStartTime; }

			void		Cancel()										{ mCancel = true; HardResume(); }
			void		SkipOperation()									{ mSkipOperation = true; SoftResume(); }
			void		SkipEntry()										{ mSkipEntry = true; SoftResume(); }
			void		SkipDirectory()									{ mSkipDirectory = true; SoftResume(); }
			void		PrintOperationStackToStream()					{ puts(mOperationStack.AsString()); }
			bool		IsAnswerPossible(answer_flags iflag)			{ return inherited::IsAnswerPossible(iflag); }
			bool		IsCalculating()	const							{ return mOperationStack.Contains(kCalculateItemsAndSize); }
			bool		IsEffectiveFileCopyRunning() const				{ return mProgressInfo.HasFileSizeProgress(); }
			const char *CurrentEntryName() const						{ return inherited::CurrentEntryName(); }
			bool		HasDialogWindow() const							{ return mDialogWindow != 0; }
			BWindow	*	DialogWindow() const;

			bool		IsOperationStringDirty() const					{ return mOperationStringDirty; }
			void		ClearOperationStringDirty()						{ mOperationStringDirty = false; }

			void		EffectiveCopyBegins()							{ mOverheadStopWatch.Suspend(); }
			void		EffectiveCopyEnds()								{ mOverheadStopWatch.Resume(); }

			bool		DidOperationBegin()								{ return mOperationBegun; }
			operation	RootOperation() const							{ return mOperationStack.RootOperation(); }
			operation	CurrentOperation() const						{ return mOperationStack.Current(); }
			operation	LastPrimaryOperation() const					{ return mOperationStack.LastPrimaryOperation(); }
			const char *LastPrimaryOperationAsString()					{ return OperationStack::AsString(LastPrimaryOperation()); }
			const char *OperationStackAsString()						{ return mOperationStack.AsString(); }
			int32		OperationStackSize() const						{ return mOperationStack.CountItems(); }
			
			void		CheckCancel();

	static	status_t	SetPoseLocation(ino_t in_dest_dir_inode, BNode &in_dest_node, const BPoint &in_point);
	static	status_t	SetPoseLocation(BEntry &in_entry, const BPoint &in_point);
	static	bool		GetPoseLocation(const BNode &node, BPoint &point);
	static	status_t	GetTrackerSettingsDir(BPath &, bool autoCreate = true);
	static	void		CreateSpecialDirs();
	
private:
			// Overridden functions
			void		InitProgressIndicator();
			bool		ErrorHandler(status_t iStatus);
			command		Interaction(interaction icode, char * = 0, char * = 0);
			
			void		NextEntryCreated(node_ref &, BNode &);
			void		DirectoryTrashed(node_ref &);
			void		AboutToDeleteOrTrash(BEntry &);

			void		OperationBegins();

			void		CommonFunctionBeforeOperations();
			bool		IsConnectedToStatusWindow() const				{ return mConnectedToStatusWindow; }


	FSDialogWindow *					mDialogWindow;
	bigtime_t							mStartTime;
	BStopWatch							mElapsedStopWatch;
	BStopWatch							mOverheadStopWatch;
	fs::EntryList						mEntryList;				// the list of entries we will operate on
	fs::EntryList::STLEntryIterator		mEntryIterator;			// an iterator for the above list
	point_list_t						mPointList;
	point_list_t::iterator				mPointListPos;
	thread_id							mWorkingThread;
	float								mPreviousTimeGuess;		// to avoid time guess jumping around, make an average of the last two
	bool								mConnectedToStatusWindow;
	bool								mInteractive;
	bool								mProgressInfoEnabled;
	bool								mOperationBegun;
	bool								mWasOverheadSWRunning;
	bool								mOperationStringDirty;
	bool								mShouldAutoPause;
	
	bool								mPause;
	bool								mAutoPaused;
	bool								mCancel;
	bool								mSkipOperation;
	bool								mSkipEntry;
	bool								mSkipDirectory;
};





// Stuffs from the old FSUtils

enum ReadAttrResult {
	kReadAttrFailed,
	kReadAttrNativeOK,
	kReadAttrForeignOK
};

ReadAttrResult ReadAttr(const BNode &, const char *hostAttrName, const char *foreignAttrName,
	type_code , off_t , void *, size_t , void (*swapFunc)(void *) = 0,
	bool isForeign = false);
	// Endian swapping ReadAttr call; endianness is determined by trying first the
	// native attribute name, then the foreign one; an endian swapping function can
	// be passed, if null data won't be swapped; if <isForeign> set the foreign endianness
	// will be read directly without first trying the native one
	
ReadAttrResult GetAttrInfo(const BNode &, const char *hostAttrName, const char *foreignAttrName,
	type_code * = NULL, size_t * = NULL);


status_t TrackerLaunch(const entry_ref *app, bool async);
status_t TrackerLaunch(const BMessage *refs, bool async, bool okToRunOpenWith = true);
status_t TrackerLaunch(const entry_ref *app, const BMessage *refs, bool async,
	bool okToRunOpenWith = true);
status_t LaunchBrokenLink(const char *, const BMessage *);

// Deprecated calls use newer calls above instead
_IMPEXP_TRACKER void FSLaunchItem(const entry_ref *, BMessage * = NULL, int32 workspace = -1);
_IMPEXP_TRACKER status_t FSLaunchItem(const entry_ref *, BMessage *,
	int32 workspace, bool asynch);
_IMPEXP_TRACKER void FSOpenWithDocuments(const entry_ref *executableToLaunch,
	BMessage *documentEntryRefs);
_IMPEXP_TRACKER status_t FSLaunchUsing(const entry_ref *ref, BMessage *listOfRefs);



// some extra directory_which values
// move these to FindDirectory.h
const uint32 B_USER_MAIL_DIRECTORY = 3500;
const uint32 B_USER_QUERIES_DIRECTORY = 3501;
const uint32 B_USER_PEOPLE_DIRECTORY = 3502;
const uint32 B_USER_DOWNLOADS_DIRECTORY = 3503;
const uint32 B_USER_DESKBAR_APPS_DIRECTORY = 3504;
const uint32 B_USER_DESKBAR_PREFERENCES_DIRECTORY = 3505;
const uint32 B_USER_DESKBAR_DEVELOP_DIRECTORY = 3506;

const int32 B_BOOT_DISK = 10000000;
	// map /boot into the directory_which enum for convenience

class WellKnowEntryList {
	// matches up names, id's and node_refs of well known entries in the
	// system hierarchy

public:
	struct WellKnownEntry {
		WellKnownEntry(const node_ref *node, directory_which which, const char *name)
			:	node(*node),
				which(which),
				name(name)
			{}

		// mwcc needs these explicitly to use vector
		WellKnownEntry(const WellKnownEntry &clone)
			:	node(clone.node),
				which(clone.which),
				name(clone.name)
			{}
		
		WellKnownEntry()
			{}
		
		node_ref node;
		directory_which which;
		const char *name;
	};
	
	static directory_which Match(const node_ref *);
	static const WellKnownEntry *MatchEntry(const node_ref *);
	static void Quit();

private:
	const WellKnownEntry *MatchEntryCommon(const node_ref *);
	WellKnowEntryList();
	void AddOne(directory_which, const char *name);
	void AddOne(directory_which, const char *path, const char *name);
	void AddOne(directory_which, directory_which base, const char *extension,
		const char *name);
	
	vector<WellKnownEntry> entries;
	static WellKnowEntryList *self;
};

bool ConfirmChangeIfWellKnownDirectory(const BEntry *entry, const char *action,
	bool dontAsk = false, int32 *confirmedAlready = NULL);


}	// namespace BPrivate

#endif // _TRACKERFSCONTEXT_H

