#include "AboutWindow.h"

using std::system;

static const window_look ABOUT_WINDOW_LOOK = B_TITLED_WINDOW_LOOK;
static const window_feel ABOUT_WINDOW_FEEL = B_NORMAL_WINDOW_FEEL;
static const uint32 ABOUT_WINDOW_FLAGS = B_NOT_RESIZABLE | B_NOT_ZOOMABLE | B_NOT_CLOSABLE;

static const uint32 ABOUT_VIEW_RESIZING_MODE = B_FOLLOW_ALL;
static const uint32 ABOUT_VIEW_FLAGS = B_WILL_DRAW;

static const uint32 ABOUT_WEBPAGE_BUTTON_CLICKED = 'awbc';
static const uint32 ABOUT_OK_BUTTON_CLICKED = 'aobc';

static const char ABOUT_WEBPAGE_BUTTON_CAPTION[] = "WebPage";
static const char ABOUT_OK_BUTTON_CAPTION[] = "OK";

static const rgb_color ABOUT_VIEW_COLOR = {200,200,200,0};

TAboutWindow::TAboutWindow(BRect _rect,const char* _title,
						const char* _app_name,const char* _version,
						const char* _copyright,
						const char* _url = "")
		:m_shown_flag(false)
{
	ASSERT(be_app != NULL);

	m_win = new __TAboutWindow(_rect,_title,_app_name,_version,
							_copyright,_url);
}

TAboutWindow::~TAboutWindow()
{
	if (m_shown_flag) m_win->Quit();
}

// ウィンドウの表示など
void TAboutWindow::Show()
{
	m_shown_flag = true; // 表示フラグを立てる

	m_win->Lock();	
	if (m_win->IsHidden() == true) m_win->Show();
	else m_win->Activate(true);
	m_win->Unlock();
}

// ビューのコンストラクタ
TAboutView::TAboutView(BRect& _rect,const char* _app_name,
					const char* _copyright,const char* _version,
					const char* _url)
	:BView(_rect,"ABOUT_MAIN_VIEW",ABOUT_VIEW_RESIZING_MODE,
			ABOUT_VIEW_FLAGS),
	  m_large_icon(NULL),m_ok_button(NULL),m_webpage_button(NULL),
	  m_app_name_string(NULL),m_copyright_string(NULL),
	  m_version_string(NULL),m_url(_url)		
{
	m_large_icon = getLargeIcon();

	// ビューの右端と左端
	float x,y;
	x = _rect.right;
	y = _rect.bottom;

	// 指定のＵＲＬがあったらボタンの作成	
	if(m_url != "")
	{
		m_webpage_button = new BButton(BRect(x-140,y-30,x-80,y-10),
							"GOTO_BUTTON",
							ABOUT_WEBPAGE_BUTTON_CAPTION,
							new BMessage(ABOUT_WEBPAGE_BUTTON_CLICKED));
		AddChild(m_webpage_button);
	}	

	m_ok_button = new BButton(BRect(x-70,y-30,x-10,y-10),
						"OK_BUTTON",
						ABOUT_OK_BUTTON_CAPTION,
						new BMessage(ABOUT_OK_BUTTON_CLICKED));							
	AddChild(m_ok_button);

	// フォントの大きさを取得してStringViewの大きさを調節する
	float string_width,string_height;
	font_height f_height;
	BFont font(be_plain_font);

	font.GetHeight(&f_height);
	string_height = f_height.ascent + f_height.descent;

	// 文字列の長さを取得して、BStringViewを決める
	string_width = font.StringWidth(_app_name);
	m_app_name_string = new BStringView
					(BRect(50,10,string_width+50,string_height+10),
					 "APP_NAME_STRING",_app_name);

	float version_left = 50+string_width;

	string_width = font.StringWidth(_copyright);
	m_version_string = new BStringView
					(BRect(version_left+10,
							10,
							version_left+string_width+10,
							10+string_height),
					"VERSION_STRING",_version);

	string_width = font.StringWidth(_copyright);
	m_copyright_string = new BStringView
					(BRect(50,100,string_width+50,string_height+100),
					 "COPYRIGHT_STRING",_copyright);

	SetViewColor(ABOUT_VIEW_COLOR);

	AddChild(m_app_name_string);
	AddChild(m_copyright_string);
	AddChild(m_version_string);
}

TAboutView::~TAboutView()
{
	delete m_large_icon;
}

void TAboutView::AttachedToWindow()
{
	if (m_webpage_button) m_webpage_button->SetTarget(this);
	m_ok_button->SetTarget(this);
	m_ok_button->MakeDefault(true);
}

void TAboutView::MessageReceived(BMessage* _msg)
{

	switch (_msg->what)
	{
	case ABOUT_OK_BUTTON_CLICKED:
		Window()->Hide();
		break;
	case	ABOUT_WEBPAGE_BUTTON_CLICKED: // URLボタンがクリックされたとき
	{
		char* arg_v[1];
		
		char url[1024];
		strcpy(url,m_url.c_str());
		arg_v[0] = url;
		
		// NetPositiveを起動
		be_roster->Launch("application/x-vnd.Be-NPOS",1,arg_v);
		Window()->Hide();
	}
		break;
	default:
		BView::MessageReceived(_msg);
		break;
	}
}

// アイコンの画像を書く
void TAboutView::Draw(BRect _update_rect)
{
	
	BRect rect = Bounds();
	BPoint draw_point(rect.Width()/2-16,rect.Height()/2-16);

	DrawBitmap(m_large_icon,draw_point);
}

// アイコンの画像を取得する
BBitmap* TAboutView::getLargeIcon()
{

	status_t ret;

	app_info info;
	ret = be_app->GetAppInfo(&info);
	ASSERT_WITH_MESSAGE(ret == B_NO_ERROR,"GetAppInfo Failed:");
#if DEBUG
	cout << "GetAppInfo_ref: " << info.ref.name << endl;
#endif

	BFile file(&info.ref,B_READ_WRITE);
	BAppFileInfo app_file_info(&file);	
	ASSERT_WITH_MESSAGE(app_file_info.InitCheck() == B_NO_ERROR,
				"BAppFileInfo Init Failed:");
	
	BBitmap* icon;
	icon = new BBitmap(BRect(0,0,31,31),B_CMAP8);

#if DEBUG
	switch(ret)
	{
	case B_BAD_VALUE:
		cout << "GetIcon:B_BAD_VALUE" << endl;
		break;
	case B_NO_INIT:
		cout << "GetIcon:B_NO_INIT" << endl;
		break;
	case B_NO_ERROR:
		cout << "GetIcon:B_NO_ERROR" << endl;
		break;
	}
#endif

	ret = app_file_info.GetIcon(icon,B_LARGE_ICON);
	ASSERT_WITH_MESSAGE(ret == B_NO_ERROR,"GetIconImage Failed:");

	return icon;
}

__TAboutWindow::__TAboutWindow(BRect _rect,const char* _title,	
						const char* _app_name,
						const char* _copyright,
						const char* _version,
						const char* _url)
	:BWindow(_rect,_title,ABOUT_WINDOW_LOOK,ABOUT_WINDOW_FEEL,
			ABOUT_WINDOW_FLAGS)
{
	_rect.OffsetTo(B_ORIGIN);
	
	m_view = new TAboutView(_rect,_app_name,_copyright,_version,_url);
	AddChild(m_view);
	m_view->MakeFocus();

}

bool __TAboutWindow::QuitRequested()
{
	return true;
}

