// CClockApp.cpp

#include "CClockApp.h"

using std::string;
using std::sprintf;
using std::ostrstream;

const char POPUP_MENU_NAME[] = "DESKBAR_POPUP_MENU";

TCClockApp::TCClockApp() 
	:BApplication(CCLOCK_SIGNATURE),
	 m_popup_menu(NULL),
	 m_multi_lang_menu(new TMultiLangMenu(MULTI_LANG_MENU_NAME))
{
	TMultiLang* lang = TMultiLang::GetMultiLang();
	if (lang->IsEmpty()) // 言語ファイルが見つからなかったらエラーを表示して終わる
	{
		(new BAlert("Error",NOT_FOUND_LANG_FILE_MESSAGE,"OK"))->Go();
		be_app->PostMessage(B_QUIT_REQUESTED);
		exit(0);
	}

	lang->AddObserver(this);

 	string window_name;
	char buffer[8192]; // ウィンドウ名をアプリケーション名とバージョン名をくっつける

	sprintf(buffer,"%s Ver.%.2f",CCLOCK_WINDOW_NAME_BASE,CCLOCK_VERSION);
	
	TConfigFile* p_config_file = 
			TConfigFile::GetConfigFile(CONFIG_FILENAME);

	if(p_config_file->IsExists() == false) 
		makeDefaultSettingFile(p_config_file);

	m_main_win = new TCClockWindow(MAIN_WINDOW_RECT,buffer);
	sprintf(buffer,"Ver.%.2f",CCLOCK_VERSION);
	m_about_window = new TAboutWindow(ABOUT_WINDOW_RECT,
								MAIN_MENU_ABOUT_CAPTION,
								CCLOCK_APP_NAME,
								CCLOCK_COPYRIGHT,
								buffer,CREATOR_URL);
}

TCClockApp::~TCClockApp()
{
}

void TCClockApp::Quit()
{
	BDeskbar deskbar;
	
	while (deskbar.HasItem(DESKBAR_VIEW_NAME))
		deskbar.RemoveItem(DESKBAR_VIEW_NAME);

	delete m_about_window;

	BApplication::Quit();
}

void TCClockApp::ReadyToRun()
{
	initPopUpMenu();

	BDeskbar deskbar;
	if (!deskbar.HasItem(DESKBAR_VIEW_NAME))
	{
		status_t ret;

		TCClockDeskbarView* view;
		view = new TCClockDeskbarView(BMessenger(this),
							DESKBAR_VIEW_NAME);

		ret = deskbar.AddItem(view);	
		ASSERT (ret == B_OK);

		delete view;
	}

	m_main_win->Show();
	
	if (m_main_win->GetParmanent()) // 常駐状態だったらウィンドウを隠す
	{
		m_main_win->Hide();
	}

	// 言語設定
	TConfigFile* config_file = TConfigFile::GetConfigFile(CONFIG_FILENAME);
	string language;
	language = config_file->GetValue(CONFIG_LANGUAGE);
	if(language != "")
	{
		TMultiLang* lang = TMultiLang::GetMultiLang();
		lang->SetLang(language.c_str());
	}	
}

void TCClockApp::AboutRequested()
{
	m_about_window->Show();
}

void TCClockApp::MessageReceived(BMessage* _msg)
{
	switch(_msg->what)
	{
	case DESKBAR_SHOW_REQUESTED:
		m_main_win->Show();
		break;
	case B_MOUSE_DOWN:
		m_main_win->Looper()->Lock();
		if (m_main_win->IsHidden())
		{
			m_main_win->Looper()->Unlock();
			
			BPoint point;
			_msg->FindPoint("where",&point);

#ifdef DEBUG
			point.PrintToStream();
#endif

			BRect rect(point.x - 5,point.y - 5,
						point.x + 5,point.y + 5);
#ifdef DEBUG
			rect.PrintToStream();
#endif			
			m_popup_menu->Go(point,true,false,rect);		
		}
		else
		{
			m_main_win->Activate();
			m_main_win->Looper()->Unlock();
		}
		
		break;
	default:
		BApplication::MessageReceived(_msg);
	}
}

void TCClockApp::LangChanged(const char* _lang)
{
	initPopUpMenu();
}

void TCClockApp::makeDefaultSettingFile(TConfigFile* _p_config_file)
{
	_p_config_file->SetValue(CONFIG_SERVERNAME,DEFAULT_SERVERNAME);

	_p_config_file->Save();
}

void TCClockApp::initPopUpMenu()
{
	if (m_popup_menu != NULL)
	{
		m_popup_menu->RemoveItem(m_multi_lang_menu);
		cleanUpPopUpMenu();
	}
	else
	{
		m_popup_menu = new TCClockDeskbarMenu(POPUP_MENU_NAME);
	}

	TMultiLang* lang = TMultiLang::GetMultiLang();

	BMenuItem* item;
	item = new BMenuItem(lang->GetString(DESKBAR_MENU_SHOW_CAPTION),
					new BMessage(DESKBAR_SHOW_REQUESTED));
	item->SetTarget(this);
	m_popup_menu->AddItem(item);

	item = new BMenuItem(lang->GetString(DESKBAR_MENU_ABOUT_CAPTION),
					new BMessage(B_ABOUT_REQUESTED));
	item->SetTarget(this);
	m_popup_menu->AddItem(item);

	m_popup_menu->AddSeparatorItem();

	item = new BMenuItem(lang->GetString(DESKBAR_MENU_QUIT_CAPTION),
					new BMessage(B_QUIT_REQUESTED));
	item->SetTarget(this);

	m_popup_menu->AddItem(m_multi_lang_menu);
	
	m_popup_menu->AddSeparatorItem();
	
	m_popup_menu->AddItem(item);

}

// メニューからアイテムを取り除く
void TCClockApp::cleanUpPopUpMenu()
{
	int32 num_of_menu = m_popup_menu->CountItems();

	while(num_of_menu-- > 0)
	{
		delete m_popup_menu->RemoveItem(static_cast<int32>(0));	
	}

}