// CClockDefs.h
// CClockの定数設定

#ifndef CCLOCK_DEFS_H_
#define CCLOCK_DEFS_H_

#include <Window.h>
#include <View.h>
#include <Rect.h>

// シグネチャ
static const char CCLOCK_SIGNATURE[] = "application/x-vnd.biggoro-CClock";
// バージョン番号
static const float CCLOCK_VERSION = 1.22f;
static const char CCLOCK_COPYRIGHT[] = "Programmed by big56";
static const char CCLOCK_APP_NAME[] = "CCLOCK";

static const char CREATOR_URL[] = "http://23.tok2.com/big56";

// メインウィンドウの基本的な名前
static const char CCLOCK_WINDOW_NAME_BASE[] = "CCLOCK";

// メインウィンドウの構築時のフラグ
static const window_look MAIN_WINDOW_LOOK   = B_TITLED_WINDOW_LOOK;
static const window_feel MAIN_WINDOW_FEEL   = B_NORMAL_WINDOW_FEEL;
static const uint32       MAIN_WINDOW_FLAGS = B_NOT_RESIZABLE | B_NOT_ZOOMABLE;

// メインのビュー構築時のフラグ
static const uint32 MAIN_VIEW_RESIZING_MODE = B_FOLLOW_ALL_SIDES;     
static const uint32 MAIN_VIEW_FLAGS = B_WILL_DRAW | B_PULSE_NEEDED;

// メッセージ定数
static const uint32 SERVER_NAME_TEXT_MODIFIED = 'sntm';
static const uint32 MAIN_OK_BUTTON_CLICKED = 'mobc';
static const uint32 PERMANENT_BUTTON_CLICKED = 'pbcl';
static const uint32 PERMANENT_CHECKBOX_CLICKED = 'pbcc';
static const uint32 PULSE_TEXT_MODIFIED = 'ptmo';
static const uint32 TIMEOUT_TEXT_MODIFIED = 'ttmo';
static const uint32 DESKBAR_SHOW_REQUESTED = 'desr';

// ウィンドウの矩形
static const BRect& MAIN_WINDOW_RECT = BRect(100,100,500,250);
static const BRect& ABOUT_WINDOW_RECT = BRect(150,150,350,300);

// ファイル名
static const char CONFIG_FILENAME[] = "big56/CClock.cfg";

// セーブ項目名
static const char CONFIG_SERVERNAME[] = "NtpServerName";
static const char CONFIG_VERSIONNAME[] = "CClockVersion";
static const char CONFIG_IS_PERMANENT[] = "IsResident";
static const char CONFIG_PULSE_RATE[] = "PulseRate";
static const char CONFIG_TIMEOUT[] = "TimeOut";
static const char CONFIG_LANGUAGE[] = "Language";

// エラーメッセージなど
//static const char CONNECT_ERROR_MESSAGE[] = "接続の際にエラーになりました。";
//static const char ADDRESS_ERROR_MESSAGE[] = "サーバーが見つかりません。";
//static const char SOCKET_ERROR_MESSAGE[] = "ソケット作成が出来ません。";
//static const char TIMEOUT_ERROR_MESSAGE[] = "しばらく待っても、有効な時間情報を取得出来ませんでした。";
//static const char NOT_VALID_ERROR_MESSAGE[] = "サーバーから有効な時間情報を取得出来ませんでした。";

static const char CONNECT_ERROR_MESSAGE[] = "CONNECT_ERROR";
static const char ADDRESS_ERROR_MESSAGE[] = "ADDRESS_ERROR";
static const char SOCKET_ERROR_MESSAGE[] = "SOCKET_ERROR";
static const char TIMEOUT_ERROR_MESSAGE[] = "TIMEOUT_ERROR";
static const char NOT_VALID_ERROR_MESSAGE[] = "NOT_VALID_ERROR";


//static const char BETWEEN_CONNECT_MESSAGE[] = "現在タイムサーバーに接続中...";
//static const char BETWEEN_CONNECT_TITLE[] = "接続中";

static const char BETWEEN_CONNECT_MESSAGE[] = "BETWEEN_CONNECT_MESSAGE";
static const char BETWEEN_CONNECT_TITLE[] = "BETWEEN_CONNECT_TITLE";


// 1900/01/01 から 1970/01/01日 に変更する時間差
#define NTP_SERVER_TIME_DIFFERENCE (((365*70)+17)*24*60*60)

static const bigtime_t DEFAULT_PULSE_RATE = 300000000; // デフォルトの更新間隔
static const bigtime_t DEFAULT_TIMEOUT = 10000000;     // デフォルトのタイムアウト

static const bigtime_t PULSE_RATE_TIMES = 1000000; // 更新間隔は秒単位
static const bigtime_t TIMEOUT_TIMES = 1000; // タイムアウトはミリ秒単位


static const bool DEFAULT_PERMANENT = false;						// デフォルトで常駐しない
static const char DEFAULT_SERVERNAME[] = "onikobe.gw.tohoku.ac.jp"; // デフォルトのサーバー名

// ビューのボタンなどに関する文字列
static const char SERVER_TEXT_CONTROL_NAME[] = "SERVER_NAME";
static const char MAIN_OK_BUTTON_NAME[] = "OK_BUTTON";
static const char PERMANENT_BUTTON_NAME[] = "PERMANENT_BUTTON";
static const char PERMANENT_CHECKBOX_NAME[] = "PERMANENT_CHECKBOX";
static const char PULSE_TEXT_CONTROL_NAME[] = "PULSE_TEXT";
static const char TIMEOUT_TEXT_CONTROL_NAME[] = "TIMEOUT_TEXT";

static const char DESKBAR_VIEW_NAME[] = "CCLOCK_DESKBAR_VIEW";

//static const char SERVER_TEXT_CONTROL_LABEL[] = "サーバー名";
//static const char MAIN_OK_BUTTON_LABEL[] = "接続";
//static const char PERMANENT_BUTTON_LABEL[] = "常駐";
//static const char PERMANENT_CHECKBOX_LABEL[] = "常駐する";
//static const char PULSE_TEXT_CONTROL_LABEL[] = "更新間隔(秒指定)";
//static const char TIMEOUT_TEXT_CONTROL_LABEL[] = "タイムアウト(ミリ秒)";

static const char SERVER_TEXT_CONTROL_LABEL[] = "SERVER_NAME";
static const char MAIN_OK_BUTTON_LABEL[] = "CONNECT";
static const char PERMANENT_BUTTON_LABEL[] = "RESIDENT";
static const char PERMANENT_CHECKBOX_LABEL[] = "RESIDENT_CHECKBOX";
static const char PULSE_TEXT_CONTROL_LABEL[] = "UPDATE_INTERVAL";
static const char TIMEOUT_TEXT_CONTROL_LABEL[] = "TIMEOUT";

//static const char MAIN_MENU_FILE_CAPTION[] = "ファイル";
//static const char MAIN_MENU_QUIT_CAPTION[] = "終了";
//static const char MAIN_MENU_HELP_CAPTION[] = "ヘルプ";
//static const char MAIN_MENU_ABOUT_CAPTION[] = "バージョン情報";

static const char MAIN_MENU_FILE_CAPTION[] = "FILE";
static const char MAIN_MENU_QUIT_CAPTION[] = "QUIT";
static const char MAIN_MENU_HELP_CAPTION[] = "HELP";
static const char MAIN_MENU_ABOUT_CAPTION[] = "ABOUT";

//static const char DESKBAR_MENU_SHOW_CAPTION[] = "ウィンドウを表示";
//static const char DESKBAR_MENU_ABOUT_CAPTION[] = "バージョン情報";
//static const char DESKBAR_MENU_QUIT_CAPTION[] = "終了";

static const char DESKBAR_MENU_SHOW_CAPTION[] = "SHOW_CCLOCK_WINDOW";
static const char DESKBAR_MENU_ABOUT_CAPTION[] = "ABOUT";
static const char DESKBAR_MENU_QUIT_CAPTION[] = "QUIT";

static const char TIME_INFO_FAST_MESSAGE[] = "TIME_INFO_FAST_MESSAGE";
static const char TIME_INFO_SLOW_MESSAGE[] = "TIME_INFO_SLOW_MESSAGE";
static const char TIME_INFO_SUIT_MESSAGE[] = "TIME_INFO_SUIT_MESSAGE";


static const char SERVER_NAME_FIELD[] = "server_name";


#endif // CCLOCK_DEFS_H_