// CClockView.h
// メインウィンドウのインターフェース構築

#ifndef CCLOCK_VIEW_H_
#define CCLOCK_VIEW_H_

class TCClockView;

#include "CClockDefs.h"
#include "CClockWindow.h"
#include "ConfigFile.h"
#include "CorrectTimeGetter.h"
#include "MultiLang.h"
#include "MultiLangView.h"

#include <TextControl.h>
#include <Button.h>
#include <Alert.h>
#include <CheckBox.h>
#include <Menu.h>
#include <MenuItem.h>
#include <MenuBar.h>

#include <string>
#include <strstream>
#include <cstdlib>

using std::string;
using std::ostrstream;

class TCClockView : public TMultiLangView
{
public:
	TCClockView(BRect _rect,const char* _name);
	~TCClockView();

	// ボタンなどのメッセージのターゲット変更
	virtual void AttachedToWindow();
	virtual void LangChanged(const char* _lang);
	virtual void MessageReceived(BMessage* _msg);
	virtual void Pulse(void); // 更新間隔ごとに呼ばれる関数

	// サーバー名を取得
	string GetServerNameString() const { return m_server_name_text->Text(); }
	string GetTimeoutString()   const { return m_timeout_text->Text(); }
	string GetPulseRateString() const { return m_pulse_rate_text->Text(); }
	bool   GetParmanentBool() const 
		{ return (m_permanent_checkbox->Value() == B_CONTROL_ON) 
		  	? true : false;
		}
		  

private:
	void initMenu(const BRect& _rect);
	void allowOnlyNum(BTextView* _text_view);
	void setEnabledByPermanent(); // 常駐のチェックボックスの値によって
							 // Enabledフラグを変更する

	void updateTextLabel();
	
	BTextControl* m_server_name_text;

	BButton*      m_ok_button;
	BMenuBar*        m_menubar;
	
	BButton*      m_permanent_button;
	BTextControl* m_pulse_rate_text;
	BCheckBox*    m_permanent_checkbox;
	BTextControl* m_timeout_text;

};

#endif // CCLOCK_VIEW_H_