// CorrectTimeGetter.h
// NTP通信の際のデータ受信支援クラス
// 受信されたデータはBMessageによって送信される
// _server_nameで指定されたサーバーにデータを取りに行き
// _handlerに指定されたハンドラにメッセージを送り付ける

#ifndef CORRECT_TIME_GETTER_H_
#define CORRECT_TIME_GETTER_H_

#include "ThreadEndpoint.h"

#include <Handler.h>
#include <Messenger.h>
#include <OS.h>
#include <ByteOrder.h>

#include <memory>
#include <string>

using std::auto_ptr;
using std::string;
using IRCLIB::TThreadEndpoint;

static const bigtime_t GETTER_DEFAULT_TIMEOUT = 10000000;

static const unsigned short NTP_PORT = 123;

// NTPパケットを取得したあとに送られるメッセージ
static const uint32 NTP_PACKET_GOT = 'ntgt';

// NTPパケットが入っているフィールド
static const char NTP_PACKET_FIELD[] = "ntp_packet";
// ローカルの送信受信時間情報が入っているフィールド
static const char LOCAL_TIME_FIELD[] = "local_time";

// パケットをちゃんと受信できたかどうかを知らせるメッセージのフィールド名
static const char IS_ERROR_FIELD[] = "is_error"; 

// NTPパケット
struct NtpPacket
{
	int32 control_word;
	int32 root_delay;
	int32 root_dispersion;
	int32 reference_identifier;
	int64 reference_timestamp;
	int64 originate_timestamp;
	int64 receive_timestamp;
	int32 transmit_timestamp_seconds;
	int32 transmit_timestamp_fractions;

	// コンストラクタはすべてをゼロに初期化
	NtpPacket() : control_word(0),root_delay(0),
				   root_dispersion(0),reference_identifier(0),
				   reference_timestamp(0),originate_timestamp(0),
				   receive_timestamp(0),transmit_timestamp_seconds(0),
				   transmit_timestamp_fractions(0) {}
	void Swap();
	// 標準出力に書き出す
	void PrintToStream();
} ;

struct LocalTimeInfo
{
	bigtime_t send_timestamp;
	bigtime_t receive_timestamp;
	LocalTimeInfo() : send_timestamp(0),receive_timestamp(0) {}
};

class TCorrectTimeGetter
{
public:
	enum { NO_ERROR = 10,SOCKET_ERROR,ADDRESS_NOT_FOUND,CONNECT_TIMEOUT_ERROR,NOT_VALID_ERROR,OTHER_ERROR };
	TCorrectTimeGetter(const char* _server_name,const BHandler* _handler,bigtime_t timeout = GETTER_DEFAULT_TIMEOUT);
	virtual ~TCorrectTimeGetter();
	
	bool Connect();

	// 初期化チェック
	int Error() { return m_error_code; }
	void SetTimeout(bigtime_t _timeout) { m_endpoint->SetTimeout(_timeout); }
private:
	static int32 ntpPacketGetFunc(void* _data);
	void errorMessageSend(int32 _error_code);
	void correctMessageSend();

	int m_error_code; 			// 内部のエラーコード
	thread_id m_getter_id;		// データ
	NtpPacket m_packet;			// サーバーのパケット
	LocalTimeInfo m_local_time_info; // ローカル時間情報

	string m_server_name;        // サーバー名

	auto_ptr<BMessenger> m_messenger;		// メッセンジャー
	auto_ptr<TThreadEndpoint> m_endpoint;	// 接続するソケット
	bigtime_t m_timeout;		// タイムアウトの設定
};

#endif // CORRECT_TIME_GETTER_H_