// MultiLangMenu.h
// 多言語のメニューを提供する

#include "MultiLangMenu.h"

const uint32 MULTI_LANGUAGE_CHANGED = 'mlch';
static const char LANGUAGE_NAME_FIELD[] = "LanguageName";
static const char MULTI_LANG_MENU_POINTER_FIELD[] = "MultiLangMenuPointer";

 
using namespace std;

// 自前メニューアイテムクラス
//--------------------------------------
class TMultiLangMenuItem : public BMenuItem
{
public:
	TMultiLangMenuItem(const char* _label,BMessage* _message,
				char _shortcut = 0,uint32 _modifiers = 0);
	TMultiLangMenuItem(BMenu* _submenu,BMessage* _message = NULL);

	virtual ~TMultiLangMenuItem();
	
	virtual status_t Invoke(BMessage* _msg);
};
//--------------------------------------

TMultiLangMenu::TMultiLangMenu(const char* _name,
				menu_layout _layout = B_ITEMS_IN_COLUMN)
	:BMenu(_name,_layout)
{
	constructMultiLangMenu();
}

TMultiLangMenu::TMultiLangMenu(const char* _name,
				float _width,float _height)
	:BMenu(_name,_width,_height)
{
	constructMultiLangMenu();
}

TMultiLangMenu::~TMultiLangMenu()
{
}

TMultiLangMenu::TMultiLangMenu(BMessage* _archive)
	:BMenu(_archive)
{
	TMultiLang* lang = TMultiLang::GetMultiLang();
	lang->AddObserver(this);

	initMultiLangMenu();
}

BArchivable* TMultiLangMenu::Instantiate(BMessage* _archive)
{
	if(validate_instantiation(_archive,"TMultiLangMenu"))
	{
		return new TMultiLangMenu(_archive);
	}
	
	return NULL;
}

status_t TMultiLangMenu::Archive(BMessage* o_archive,bool _deep = true) const
{
	status_t ret;
	ret = BMenu::Archive(o_archive,_deep);
	if (ret != B_OK) return ret;

	return B_OK;
}

void TMultiLangMenu::MessageReceived(BMessage* _msg)
{
	switch (_msg->what)
	{
	case MULTI_LANGUAGE_CHANGED:
		{
		BString lang_name;
		_msg->FindString(LANGUAGE_NAME_FIELD,&lang_name);

		initMultiLangMenu(lang_name.String()); // メニューの初期化
		
		TMultiLang* lang = TMultiLang::GetMultiLang();
		lang->SetLang(lang_name.String()); // 言語の変更
		break;
		}			
	default:
		BMenu::MessageReceived(_msg);
		break;
	}
}

// 言語変更時の設定
void TMultiLangMenu::LangChanged(const char* _lang)
{
	initMultiLangMenu();
}

// コンストラクタの初期化関数関数
void TMultiLangMenu::constructMultiLangMenu()
{
	TMultiLang* lang = TMultiLang::GetMultiLang();
	lang->AddObserver(this);
	
	initMultiLangMenu();
}

void TMultiLangMenu::initMultiLangMenu(const char* _lang = NULL)
{
	// 今までのアイテムの解放
	int32 count = CountItems();
	while (count-- > 0)
	{
		delete RemoveItem(static_cast<int32>(0));
	}

	TMultiLang* lang = TMultiLang::GetMultiLang();
	
	// 言語の選択
	string search_lang;
	if (_lang != NULL)
	{
		search_lang = _lang; // 指定されていたらその言語を検索
	}
	else
	{
		search_lang = lang->GetLangFileName(); // 指定がなかったらデフォルト
	}

	// 自分自身の名前の更新
	SetName(lang->GetStringFromOtherLang(search_lang.c_str(),"language") );

	string* lang_caption = lang->GetLangListFromOtherLang(search_lang.c_str() );
	ASSERT(lang_caption != NULL);  // 言語名(母国語で)の一覧取得

	string* lang_name = lang->GetLangListFromFileName();
	ASSERT(lang_name != NULL); // 言語名(ファイル名で)の一覧取得

	size_t size = lang->GetLangListSize();
	
	for (size_t i = 0;i < size;i++)
	{
		TMultiLangMenuItem* p_menuitem;	
		BMessage* p_message;
		p_message = new BMessage(MULTI_LANGUAGE_CHANGED);
		p_message->AddString(LANGUAGE_NAME_FIELD,
							lang_name[i].c_str() );
		p_message->AddPointer(MULTI_LANG_MENU_POINTER_FIELD,
							this);
	
		if (lang_caption[i] == lang_name[i])
		{
			p_menuitem = new TMultiLangMenuItem(lang_caption[i].c_str(),p_message);
		}
		else
		{
			string show_string;
			show_string = lang_caption[i] + "(" + lang_name[i] + ")";
			p_menuitem = new TMultiLangMenuItem(show_string.c_str(),p_message);
		}

		// 現在選択されている言語だったらマーキング
		if (lang_name[i] == search_lang) p_menuitem->SetMarked(true);

		AddItem(p_menuitem);
	}

	delete[] lang_name;
	delete[] lang_caption;		

}

//-------------------------------------------------------------
// 自前のメニューアイテムの定義

TMultiLangMenuItem::TMultiLangMenuItem
		(const char* _label,BMessage* _message,
				char _shortcut = 0,uint32 _modifiers = 0)
		:BMenuItem(_label,_message,_shortcut,_modifiers)
{
}


TMultiLangMenuItem::TMultiLangMenuItem	(BMenu* _submenu,BMessage* _message = NULL)
		:BMenuItem(_submenu,_message)
{
}

TMultiLangMenuItem::~TMultiLangMenuItem()
{
}

// Invokerは、ターゲットのMessageReceived()を呼ぶだけ
status_t TMultiLangMenuItem::Invoke(BMessage* _msg)
{
	BMessage* send_message = Message();
	ASSERT(send_message != NULL);

	TMultiLangMenu* target_menu;
#ifdef DEBUG
	ASSERT(send_message->FindPointer(MULTI_LANG_MENU_POINTER_FIELD,
					    reinterpret_cast<void**>(&target_menu)) == B_OK);
#else	
	send_message->FindPointer(MULTI_LANG_MENU_POINTER_FIELD,
					reinterpret_cast<void**>(&target_menu));
#endif	
	
	target_menu->MessageReceived(send_message);
	return B_OK;
}