// ThreadEndpoint.cpp
// マルチスレッドに対応したBNetEndpointの実装
// BNetEndpointの関数を呼ぶのにBLockerでLockしてから呼び出すだけ
// 使用方法はBNetEndpointと同じなので省略


#include "ThreadEndpoint.h"

namespace IRCLIB
{
TThreadEndpoint::TThreadEndpoint(int protocol = SOCK_STREAM)
		:BNetEndpoint(protocol)
{
	init();	
}

TThreadEndpoint::TThreadEndpoint(const BNetEndpoint& _address)
		:BNetEndpoint(_address)
{
	init();	
}

TThreadEndpoint::TThreadEndpoint(BMessage *archive)
		:BNetEndpoint(archive)
{
	init();
}

TThreadEndpoint::~TThreadEndpoint()
{
}

BNetEndpoint* TThreadEndpoint::Accept(int32 timeout = -1)
{
	BNetEndpoint* p_tmp;
	m_locker->Lock();
	p_tmp = BNetEndpoint::Accept(timeout);
	m_locker->Unlock();
	return p_tmp;
}

status_t TThreadEndpoint::Bind(const BNetAddress& address)
{
	status_t tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Bind(address);	
	m_locker->Unlock();
	return tmp;
}

status_t TThreadEndpoint::Bind(int port = 0)
{
	status_t tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Bind(port);	
	m_locker->Unlock();
	return tmp;
}

void     TThreadEndpoint::Close()
{
	m_locker->Lock();
	TThreadEndpoint::Close();	
	m_locker->Unlock();
}

status_t TThreadEndpoint::Connect(const BNetAddress& address)
{
	status_t tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Connect(address);	
	m_locker->Unlock();
	return tmp;
}

status_t TThreadEndpoint::Connect(const char *address,int port)
{
	status_t tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Connect(address,port);	
	m_locker->Unlock();
	return tmp;
}
	
bool     TThreadEndpoint::IsDataPending(bigtime_t timeout=0)
{
	bool tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::IsDataPending(timeout);	
	m_locker->Unlock();
	return tmp;
}
	
status_t TThreadEndpoint::Listen(int backlog = 5)
{
	status_t tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Listen(backlog);	
	m_locker->Unlock();
	return tmp;
}
	
int32    TThreadEndpoint::Receive(void* buffer,size_t size,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Receive(buffer,size,flags);	
	m_locker->Unlock();
	return tmp;
}

int32    TThreadEndpoint::Receive(BNetBuffer& buffer,size_t size,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Receive(buffer,size,flags);	
	m_locker->Unlock();
	return tmp;
}

int32    TThreadEndpoint::ReceiveFrom(void* buffer,size_t size,
								BNetAddress& from,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::ReceiveFrom(buffer,size,from,flags);	
	m_locker->Unlock();
	return tmp;
}

int32    TThreadEndpoint::ReceiveFrom(BNetBuffer& buffer,size_t size,
								BNetAddress& from,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::ReceiveFrom(buffer,size,from,flags);	
	m_locker->Unlock();
	return tmp;
}
	
int32    TThreadEndpoint::Send(const void* buffer,size_t size,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Send(buffer,size,flags);
	m_locker->Unlock();
	return tmp;
}

int32    TThreadEndpoint::Send(BNetBuffer& buffer,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::Send(buffer,flags);
	m_locker->Unlock();
	return tmp;
}
	
int32    TThreadEndpoint::SendTo(const void* buffer,size_t size,
					 	const BNetAddress& to,int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::SendTo(buffer,size,to,flags);	
	m_locker->Unlock();
	return tmp;
}

int32    TThreadEndpoint::SendTo(BNetBuffer& buffer,const BNetAddress& to,
						int flags=0)
{
	int32 tmp;
	m_locker->Lock();
	tmp = BNetEndpoint::SendTo(buffer,to,flags);	
	m_locker->Unlock();
	return tmp;
}

void TThreadEndpoint::init()
{
	m_locker.reset(new BLocker());
}

}