// ThreadEndpoint.h
// マルチスレッドに対応したBNetEndpointの宣言

#ifndef THREAD_NETENDPOINT_H_
#define THREAD_NETENDPOINT_H_

#include <NetEndpoint.h>
#include <Locker.h>
#include <memory>  // auto_ptr

using namespace std;

namespace IRCLIB
{

class TThreadEndpoint : public BNetEndpoint
{
public:
	TThreadEndpoint(int protocol = SOCK_STREAM);
	TThreadEndpoint(const BNetEndpoint&);
	TThreadEndpoint(BMessage *archive);
	virtual ~TThreadEndpoint();

	virtual BNetEndpoint* Accept(int32 timeout = -1);

	virtual status_t Bind(const BNetAddress& address);
	virtual status_t Bind(int port = 0);

	virtual void     Close();

	virtual status_t Connect(const BNetAddress& address);
	virtual status_t Connect(const char *address,int port);
	
	virtual bool     IsDataPending(bigtime_t timeout=0);
	
	virtual status_t Listen(int backlog = 5);
	
	virtual int32    Receive(void* buffer,size_t size,int flags=0);
	virtual int32    Receive(BNetBuffer& buffer,size_t size,int flags=0);

	virtual int32    ReceiveFrom(void* buffer,size_t size,
							BNetAddress& from,int flags=0);
	virtual int32    ReceiveFrom(BNetBuffer& buffer,size_t size,
							BNetAddress& from,int flags=0);
	
	virtual int32    Send(const void* buffer,size_t size,int flags=0);
	virtual int32    Send(BNetBuffer& buffer,int flags=0);
	
	virtual int32    SendTo(const void* buffer,size_t size,
					 	const BNetAddress& to,int flags=0);
	virtual int32    SendTo(BNetBuffer& buffer,const BNetAddress& to,
						int flags=0);

private:
	void init();

	auto_ptr<BLocker> m_locker;
};

}

#endif // THREAD_NETENDPOINT_H_
