// WaitWindow.cpp
// 待ち受けウィンドウクラスの実装

#include "WaitWindow.h"

const window_look WAIT_WINDOW_LOOK = B_TITLED_WINDOW_LOOK;
const window_feel WAIT_WINDOW_FEEL = B_NORMAL_WINDOW_FEEL;
const uint32 WAIT_WINDOW_FLAGS = B_NOT_RESIZABLE | B_NOT_CLOSABLE | B_NOT_ZOOMABLE;

const float WAIT_WINDOW_EXTEND = 5.0;

TWaitWindow::TWaitWindow(BRect _rect,const char* _title,const char* _show_string)
	:m_win(NULL)
{
	init(_rect,_title,_show_string);
}

TWaitWindow::TWaitWindow(BPoint _left_top,const char* _title,const char* _show_string)
	:m_win(NULL)
{
	BFont font(be_plain_font);
	float width = font.StringWidth(_show_string);
	font_height height;
	font.GetHeight(&height);
	float left = _left_top.x;
	float top = _left_top.y;


	// 文字列から計算した大きさをもとにBRectを構築
	BRect rect(left,top,left + width + WAIT_WINDOW_EXTEND,
					top + height.ascent + height.descent
						 + WAIT_WINDOW_EXTEND);
						 
	init(rect,_title,_show_string);
}

/*******************************
 * Begin関数
 * ウィンドウを表示する関数
 */
bool TWaitWindow::Begin()
{
	m_win = new BWindow(m_rect,m_title.c_str(),
					    WAIT_WINDOW_LOOK,
					    WAIT_WINDOW_FEEL,
					    WAIT_WINDOW_FLAGS); 
	m_win->AddChild(m_string);
	m_win->Show();
	
	return true;
}

/*******************************
 *  End関数
 *  ウィンドウを消去する関数
 */
void TWaitWindow::End()
{
	m_win->Hide();
	m_win->Quit();
}

void TWaitWindow::init(BRect _rect,const char* _title,const char* _show_string)
{
	m_rect = _rect;	
	m_title = _title;

	_rect.OffsetTo(B_ORIGIN);

	m_string = new BStringView(_rect,"WAIT_WINDOW_STRING",_show_string);
	m_string->SetAlignment(B_ALIGN_CENTER);
}
