/*	ntpmagic.h

	Tous nos #defines, toutes nos constantes ....
	NetWorkTime Client (c)1997 par Tsk aka Hirlimann L.
	softkid@multimania.com
	
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
*/

#ifndef _NTPMAGIC_H
#define _NTPMAGIC_H

#include <stdio.h>
#include <stdlib.h>

/* Nos prefs, un fichier text constitué de :
	Un unsigned char qui représente la différence GMT,
	un deuxieme unsigned char pour mise à jour Automatique
	dès le déméarage de l'appli (ie depuis bootscript ),
	une chaine de caractère donnant l'adresse du serveur
	ntp.
*/

/* La structure du paquet que l'on envoi au serveur
	ca permet de pas trop ce faire chier pour remplir
	les champs
*/
struct paquet {
 char	li_vn_mode;	//leap, version, mode
 char	stratum;	// peer stratum
 char	ppoll;		//peer polling interval
 signed char	precision;
 					//peer clock precison
 long	rootdelay;	//distance to primary clock (64 bits)

 long	rootdispersion;
 					//clock dispersion
 unsigned int	refID;
 					//refernec clock ID
 long	reftime1;
 long	reftime2;	//last clock update
 long	org1;
 long	org2;		//originate time stamp
 long	rec1;
 long	rec2;		//received time stamp;
 unsigned long	xm1;
 uint32	xm2;		//tramsit time stamp
};
 			
/* Divers messages */

#define ACTION_MESSAGE	'GetT'	// pour se connecter au serveur
#define SAVE_PREFS		'Spfs'	// Pour sauvegarder les preferences

#define DOSSIER_PREF "hms"
#define FICHIER_PREF "ntp_prefs"
#define APP_SIGN "application/x-vnd.hms-networktime"

/* Quelques valeurs symboliques */
#define	DIFF_NTP_BeOS	(70*365.25*24*60*60) // difference 1900/1970 en secondes
												
#define DIFF_SERVER	 (70*365.25*24*60*60)+(12*60*60)// diff UTC GMT
#define LA_TAILLE_DE_LA_POLICE 10

#define	NTP_PORT	123 // ie Assigned numbers
#define FP_SECOND       (0x10000)
#define NTPDATE_PRECISION	(-6)
#define	NTPDATE_DISTANCE	FP_SECOND
#define	NTPDATE_DISP	FP_SECOND
#define NTPDATE_REFID	(0)
#define TAILLE_PAQUET	48
#define   LEAP_NOTINSYNC  0x3     /* overload, clock is free running */ 
// quelques macros
#define PKT_LI_VN_MODE(li, vn, md) \
        ((u_char)((((li) << 6) & 0xc0) | (((vn) << 3) & 0x38) | ((md) & 0x7)))
#define   MODE_CLIENT     3       /* client mode */ 
#endif