#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "AmplifierFilter.h"

/*******************************************************
*   
*******************************************************/
AmplifierFilter::AmplifierFilter(bool b) : RealtimeFilter(Language.get("AMPLIFIER"), b)
{

}

/*******************************************************
*   
*******************************************************/
BView *AmplifierFilter::ConfigView()
{
	BRect r(0,0,200,60);

	BView *view = new BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	view->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	r.InsetBy(8,8);
	r.bottom = r.top + 23;
	value = new SpinSlider(r, NULL, Language.get("LEVEL"), new BMessage(CONTROL_CHANGED), 1, 300);
	value->SetValue(Prefs.filter_amplifier_value);
	view->AddChild(value);

	return view;
}

void AmplifierFilter::UpdateValues()
{
	Prefs.filter_amplifier_value = value->Value();
}

/*******************************************************
*   
*******************************************************/
void AmplifierFilter::FilterBuffer(float *buffer, size_t size)
{
	float amp = Prefs.filter_amplifier_value/100.0;
	float tmp;

	for (size_t i=0; i<size; i++){
		tmp = *buffer * amp;
		if (tmp>1.0)	tmp = 1.0;
		if (tmp<-1.0)	tmp = -1.0;
		*buffer++ = tmp;
	}
}
