#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "AnalyzeWindow.h"
#include "main.h"

#define UPDATE		'updt'
#define QUIT			'quit'
#define SET				'setF'

/*******************************************************
*   
*******************************************************/
AnalyzeWindow::AnalyzeWindow(BRect r, const char *name)
	: BWindow(r,name, B_FLOATING_WINDOW_LOOK,B_FLOATING_APP_WINDOW_FEEL, B_NOT_ZOOMABLE | B_AVOID_FOCUS)
{
	// 25 frames per second by default
	m_frames = 25;
	m_count = 0;
	// set the playHook
	m_index = Pool.SetPlayHook( _PlayBuffer, PLAY_HOOKS/2, (void*)this);

	SetPulseRate(50000);
	Run();
	Show();
}

/*******************************************************
*   
*******************************************************/
void AnalyzeWindow::PlayBuffer(float *buffer, size_t size)
{
}

/*******************************************************
*   
*******************************************************/
void AnalyzeWindow::_PlayBuffer(float *buffer, size_t size, void *cookie)
{
	AnalyzeWindow *win = (AnalyzeWindow*)cookie;	// cast to our own clas

	// process effect
	win->PlayBuffer(buffer, size);

	// update with frames/second
	win->m_count -= size;
	if (win->m_count <0){
		win->m_count = (int)Pool.system_frequency*2/win->m_frames;
		win->PostMessage(UPDATE);
	}
}

/*******************************************************
*   
*******************************************************/
int32 AnalyzeWindow::FramesPerSecond()
{
	return m_frames;
}

void AnalyzeWindow::SetFramesPerSecond(int32 frames)
{
	m_frames = frames;
}

/*******************************************************
*   
*******************************************************/
bool AnalyzeWindow::QuitRequested(){
	Pool.RemovePlayHook( _PlayBuffer, m_index );
	return true;
}

/*******************************************************
*   
*******************************************************/
void AnalyzeWindow::MessageReceived(BMessage* msg){
	BView *view;

	switch(msg->what){
	case UPDATE:
		view = ChildAt(0);
		if (view)	view->Invalidate();
		break;

	default:
		BWindow::MessageReceived(msg);
	}
}
