/*******************************************************
*   Refraction©
*   
*   This file may be used under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    June 2002
*   @license Refraction SDK Code
*
*******************************************************/
#ifndef _BITMAP_DRAWER_H
#define _BITMAP_DRAWER_H

#include <Bitmap.h>
#include "Globals.h"

class BitmapDrawer
{
  public:
	// construction
	BitmapDrawer(BBitmap *bitmap);
	~BitmapDrawer();
	
	rgb_color GetRGB(int32 x, int32 y);
	rgb_color GetRGB(BPoint);
	rgb_color GetBilinearRGB(float x, float y);		// get with bilinear filtering
	rgb_color GetBilinearRGB(BPoint p);
	void PlotRGB(int32 x, int32 y, rgb_color c);
	void PlotRGB(BPoint p, rgb_color c);

	rgb_color GetBGR(int32 x, int32 y);
	rgb_color GetBGR(BPoint);
	void PlotBGR(int32 x, int32 y, rgb_color c);
	void PlotBGR(BPoint p, rgb_color c);
	
  private:
  	BBitmap *mBitmap;
  	uint8 *mBits;
	int32 mWidth;
	int32 mRight;
	int32 mBottom;
	BRect mBounds;
	
	int32 *mHeightLookup;
	int32 *mHeightLookup2;

	int32 eDrawMode;		// draw mode for Draw functions
	rgb_color mHighColor;	// foreground color
	rgb_color mLowColor;	// background color
};

#endif
