#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "CleanFilter.h"
#include "main.h"

#define CLEAN_BUFFER_SIZE	128
/*******************************************************
*   
*******************************************************/
CleanWindow::CleanWindow(bool b) : RealtimeFilter(Language.get("CLEAN"), b)
{
	// can do some initiation here
	samples = 10;
	treshold = 20;
}

/*******************************************************
*   
*******************************************************/
BView *CleanWindow::ConfigView()
{
	BRect r(0,0,200,140);

	BView *view = new BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	view->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	r.InsetBy(8,8);
	r.bottom = r.top + 23;
	delay = new SpinSlider(r, NULL, Language.get("AREA"), new BMessage(CONTROL_CHANGED), 1, CLEAN_BUFFER_SIZE);
	delay->SetValue(samples);
	view->AddChild(delay);

	r.OffsetBy(0,40);
	damping = new SpinSlider(r, NULL, Language.get("MAIN"), new BMessage(CONTROL_CHANGED), 1, CLEAN_BUFFER_SIZE);
//	damping->SetValue(main_samples);
	view->AddChild(damping);

	r.OffsetBy(0,40);
	gain = new SpinSlider(r, NULL, Language.get("TRESHOLD"), new BMessage(CONTROL_CHANGED), 1, 100);
	gain->SetValue(treshold);
	view->AddChild(gain);

	return view;
}

void CleanWindow::UpdateValues()
{
//	Prefs.filter_room_delay = delay->Value()/1000.0;
//	Prefs.filter_room_gain = gain->Value()/200.0;
//	Prefs.filter_room_damping = damping->Value()/200.0;

	samples = delay->Value();
	treshold = gain->Value();

/*	// wipe buffer
	for (int32 i=0; i<CLEAN_BUFFER_SIZE; i++)
		delay_buffer[i] = 0;
*/
}

/*******************************************************
*   Init & exit
*******************************************************/
bool CleanWindow::InitFilter(float f, int32 c, int32 pass, int32 size)
{
	RealtimeFilter::InitFilter(f, c, pass, size);

	delay_buffer = new float[ CLEAN_BUFFER_SIZE*m_channels ];
	for (int32 i=0; i<CLEAN_BUFFER_SIZE*m_channels; i++)
		delay_buffer[i] = 0;

	pBuffer = 0;
	left_gain = 0;
	right_gain = 0;

	return true;
}

void CleanWindow::DeAllocate()
{
	delete[] delay_buffer;
}

/*******************************************************
*   
*******************************************************/
void CleanWindow::FilterBuffer(float *buffer, size_t size)
{
	float left = 0, right = 0;
	float gain = treshold/100.0f;
	
	int32 sample_div = samples * m_channels;

	if (m_channels == 2){
// Stereo
		for (size_t i=0; i<size; i+=2){

			left = buffer[i+0];
			right = buffer[i+1];

			// compair gain
			int32 count = MIN( pBuffer, sample_div);
			left_gain = 0;
			right_gain = 0;
			for (int32 x = 0; x < count; x += 2) {
				left_gain += delay_buffer[ (pBuffer - count + x) % sample_div ];
				right_gain += delay_buffer[ (pBuffer - count + x + 1) % sample_div ];
			}
			
			left_gain = left_gain*2/count;
			right_gain = right_gain*2/count;

			if (fabs(left_gain - left) > gain) {
				buffer[i+0] = left_gain;
				delay_buffer[ pBuffer % sample_div ] = left_gain;
			} else
				delay_buffer[ pBuffer % sample_div ] = left;

			if (fabs(right_gain - right) > gain) {
				buffer[i+1] =  right_gain;
				delay_buffer[ (pBuffer+1) % sample_div ] = right_gain;
			}
			delay_buffer[ (pBuffer+1) % sample_div ] = right;
	
			pBuffer += 2;
		}
	}else if (m_channels ==1 ){
// Mono	
	}
}
