/*******************************************************
*   SampleStudio©
*   
*   This file may be used under under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (frans@xentronix.com)
*   @date    Mar 14 2002
*******************************************************/

#include <Alert.h>
#include <Message.h>
#include <Messenger.h>
#include <Application.h>
#include <stdio.h>

#include "Globals.h"
#include "CommonClass.h"

CommonClass Common;

/*******************************************************
*   
*******************************************************/
CommonClass::CommonClass(){
	if((commonSem = create_sem(1, "Common Sem")) < 0){
		debugger("Create Common Sem failed");
	}
}

/*******************************************************
*   
*******************************************************/
CommonClass::~CommonClass(){
	delete_sem(commonSem);
}

/*******************************************************
*   
*******************************************************/
void CommonClass::AddTip(BView *v,const char *tip){
	Pool.AddTip(v,tip);
}

/*******************************************************
*   
*******************************************************/
/*
void CommonClass::SetStatus(const char *s){
   acquire_sem(commonSem);
   if(s == NULL){return;}
   project_entry *pje = NULL;
   int32 pid = IPool.GetCurrentProj();
   pje = IPool.GetProject(pid);
   if(pje == NULL){ return; }
   if(pje->doc == NULL){ return; }
   BMessage *status = new BMessage(STATUS);
   status->AddString("Istatus",s);
   (pje->doc)->PostMessage(status);
   release_sem(commonSem);
}
*/

/*******************************************************
*   
*******************************************************/
/*
void CommonClass::UpdateProgress(int32 precentcomplete){
   acquire_sem(commonSem);
   project_entry *pje = NULL;
   int32 pid = IPool.GetCurrentProj();
   pje = IPool.GetProject(pid);
   if(pje == NULL){ return; }
   if(pje->doc == NULL){ return; }
   BMessage *status = new BMessage(PROGRESS);
   status->AddInt32("Iprogress",precentcomplete);
   (pje->doc)->PostMessage(status);   
   release_sem(commonSem);
}
*/

/*******************************************************
*   
*******************************************************/
const char* CommonClass::GetLanguageKey(const char *key){
   return Language.get(key);
}

/*******************************************************
*   This should set the zoom for the current document
*   and not global alowing much fun!
*******************************************************/
/*
void CommonClass::SetZoom(double z){
   acquire_sem(commonSem);
   project_entry *pje = IPool.GetProject(IPool.GetCurrentProj());
   if(pje == NULL){
      //Cant set zoom of a null proj
      return;
   }
   if(z <= 1){
      // thats a little too small for me 
      return;
   }
   
   pje->doc->SetZoom(z);
   SendMessage(BROADCAST,new BMessage(I_COMMON_CHANGED));
   release_sem(commonSem);
}
*/

/*******************************************************
*   
*******************************************************/
/*
double CommonClass::GetZoom(){
   project_entry *pje = IPool.GetProject(IPool.GetCurrentProj());
   if(pje == NULL){
      //Cant get zoom of a null proj
      return 100;
   }
   if(pje->doc == NULL){
      return 100;
   }
   
   return pje->doc->GetZoom();
}
*/
