/*******************************************************
*   SampleStudio©
*   
*   This file may be used under under the license as
*   stated below. For more information about License
*   types see the included LICENSE file. If you did 
*   not recive a copy of that file contact the author.
*   
*   @author  Frans van Nispen (frans@xentronix.com)
*   @date    Mar 14 2002
*******************************************************/

#ifndef _COMMON_H
#define _COMMON_H

#include <List.h>
#include <Looper.h>
#include <OS.h>
#include <Point.h>

class CommonClass{
 public:
	CommonClass();
	~CommonClass();
    
	// Zoom factor methods
//	void SetZoom(int32 precent = 100);
//	int32 GetZoom() const;
   
	// Things to let your plugin give the user 
	// a little feadback to how things are going
	// UpdateProgress takes a precentage from 0-100
//	void SetStatus(const char *format,...) const;
//	void UpdateProgress(int32 precent) const;
   
	// Get a language specific key from the users language file
	// To install a new key append your pluginname_key to the 
	// appropriate language file
	const char* GetLanguageKey(const char *key);
   
	// Add a tool tip to a view
	// a null tip removes its entry
	void AddTip(BView *v, const char *tip = NULL);
	
public:

private:
   CommonClass(const CommonClass&);
   CommonClass &operator=(const CommonClass&);

   sem_id commonSem;
   uint32 _reserved[8];
};

extern CommonClass Common; // Included so you don't have to 
#endif





